// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 69 1.4.1.3 source/core/collect/iaseq.h, collection, ioc.v400, 980918 
#ifndef _IASEQ_
#define _IASEQ_

#include <iasqntl.h>
#include <iiaseq.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IASequence :
  public IASequentialCollection <Element> {

  typedef  IASequentialCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:


           IASequence
                            (INotifier&);


          ~IASequence
                            ();

  long     compare          (IASequence <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
protected:

           IASequence
                            ();

           IASequence
                            (IASequence <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IASequence <Element> const&);












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaseq.inl>






#pragma info (restore)


#endif // _IASEQ_
