// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 67 1.5.1.3 source/core/collect/iasb.h, collection, ioc.v400, 980918 
#ifndef _IASB_
#define _IASB_

#include <iaeqsrt.h>
#include <iiasb.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IASortedBag :
  public IAEqualitySortedCollection <Element> {

  typedef  IAEqualitySortedCollection <Element> Inherited;

  typedef  IASortedBagImpl Implementation;

public:


           IASortedBag
                            (INotifier&);


          ~IASortedBag
                            ();




  void     addDifference    (IASortedBag <Element> const&,
                             IASortedBag <Element> const&); 




  void     addIntersection  (IASortedBag <Element> const&,
                             IASortedBag <Element> const&);




  void     addUnion         (IASortedBag <Element> const&,
                             IASortedBag <Element> const&);

  long     compare          (IASortedBag <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     differenceWith   (IASortedBag <Element> const&);




  void     intersectionWith (IASortedBag <Element> const&);

  INumber  numberOfDifferentElements
                            () const;

  bool     setToNextDifferentElement
                            (ICursor&) const;




  void     unionWith        (IASortedBag <Element> const&);

  bool     operator==       (IASortedBag
                              <Element> const&) const;

  bool     operator!=       (IASortedBag
                              <Element> const&) const;

protected:

           IASortedBag
                            ();

           IASortedBag
                            (IASortedBag <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IASortedBag <Element> const&);














};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iasb.inl>






#pragma info (restore)


#endif // _IASB_
