// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 62 1.5.1.3 source/core/collect/iarel.h, collection, ioc.v400, 980918 
#ifndef _IAREL_
#define _IAREL_

#include <iaeqkey.h>
#include <iiarel.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IARelation :
  public IAEqualityKeyCollection <Element, Key> {

  typedef  IAEqualityKeyCollection <Element, Key> Inherited;

  typedef  IARelationImpl Implementation;

public:


           IARelation
                            (INotifier&);


          ~IARelation
                            ();




  void     addDifference    (IARelation <Element, Key> const&,
                             IARelation <Element, Key> const&); 




  void     addIntersection  (IARelation <Element, Key> const&,
                             IARelation <Element, Key> const&);




  void     addUnion         (IARelation <Element, Key> const&,
                             IARelation <Element, Key> const&);




  void     differenceWith   (IARelation <Element, Key> const&);




  void     intersectionWith (IARelation <Element, Key> const&);




  void     unionWith        (IARelation <Element, Key> const&);

  bool     operator==       (IARelation
                              <Element, Key> const&) const;

  bool     operator!=       (IARelation
                              <Element, Key> const&) const;

protected:

           IARelation
                            ();

           IARelation
                            (IARelation <Element, Key> const&);

  bool     locateNext       (Element const&, ICursor&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IARelation <Element, Key> const&);













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iarel.inl>






#pragma info (restore)


#endif // _IAREL_
