// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 59 1.4.1.3 source/core/collect/iaqu.h, collection, ioc.v400, 980918 
#ifndef _IAQU_
#define _IAQU_

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaseq.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IAQueue :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:


           IAQueue
                            (INotifier&);


          ~IAQueue
                            ();




  void     addAsLast        (Element const&);




  void     addAsLast        (Element const&, ICursor&);

  long     compare          (IAQueue <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     dequeue          ();




  void     dequeue          (Element&);




  void     enqueue          (Element const&);




  void     enqueue          (Element const&, ICursor&);




  void     removeFirst      ();

protected:

           IAQueue
                            ();

           IAQueue
                            (IAQueue <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAQueue <Element> const&);



















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaqu.inl>






#pragma info (restore)


#endif // _IAQU_
