// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 56 1.5.1.3 source/core/collect/iapqu.h, collection, ioc.v400, 980918 
#ifndef _IAPQU_
#define _IAPQU_

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaksb.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IAPriorityQueue :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IAKeySortedBagImpl Implementation;

public:


           IAPriorityQueue
                            (INotifier&);


          ~IAPriorityQueue
                            ();

  long     compare          (IAPriorityQueue <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  bool     containsAllKeysFrom
                            (IARestrictedAccessCollection
                              <Element> const&) const;

  bool     containsElementWithKey
                            (Key const&) const;




  void     dequeue          ();




  void     dequeue          (Element&);

  Element const&
           elementWithKey   (Key const&) const;




  void     enqueue          (Element const&);




  void     enqueue          (Element const&, ICursor&);

  Key const&
           key              (Element const&) const;

  bool     locateElementWithKey
                            (Key const&, ICursor&) const;

  bool     locateNextElementWithKey
                            (Key const&, ICursor&) const;




  bool     locateOrAddElementWithKey
                            (Element const&);




  bool     locateOrAddElementWithKey
                            (Element const&, ICursor&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;




  void     removeFirst      ();

  bool     setToNextWithDifferentKey
                            (ICursor&) const;

protected:

           IAPriorityQueue
                            ();

           IAPriorityQueue
                            (IAPriorityQueue <Element, Key> const&);

private:

  static
  Implementation&
           ImplOf           (IAPriorityQueue <Element, Key> const&);





































};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iapqu.inl>






#pragma info (restore)


#endif // _IAPQU_
