// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 55 1.4.1.3 source/core/collect/iappl.h, collection, ioc.v400, 980918 
#ifndef _IAPPL_
#define _IAPPL_

#include <iglobals.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IApplicator
{
public:

  virtual
  bool applyTo          (Element&) = 0;

protected:

private:









};

template <class Element>
class IConstantApplicator 
{
public:

  virtual
  bool applyTo          (Element const&) = 0;

protected:

private:









};

class IInternalApplicator 
{
public:

  virtual
  bool applyTo          (void*)
           { return true;
           }

protected:

private:









};

#pragma enum(pop)
#pragma pack(pop)

inline bool
__applFunc (void* element, void* applicator)
{



  return ((IInternalApplicator*)applicator)->applyTo (element);
}

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#endif // _IAPPL_
