// Revision: 79 1.6.1.5 source/ui/baseapp/iapp.hpp, application, ioc.v400, 980918  
#ifndef _IAPP_
#define _IAPP_
/*----------------------------------------------------------------------------*/
/* FILE NAME: iapp.hpp                                                        */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the class(es):                                            */
/*     IApplication                                                           */
/*     ICurrentApplication                                                    */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <ingapp.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>
#include <ireslib.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICurrentApplication;
class ICurrentApplicationData;
class IResourceLibrary;
class IColorMap;
class IString;
struct pib_s;

#pragma enum(4)
#pragma pack(push,4)


class IApplication : public INonGUIApplication {
typedef INonGUIApplication
  Inherited;
public:
/*---------------------------- Process Information ---------------------------*/
static ICurrentApplication
 &current ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  IApplication ( const IProcessId& id );
virtual
 ~IApplication ( );

private:
/*---------------------------------- Private ---------------------------------*/
static ICurrentApplication
 *pCurrent;
}; // IApplication


class ICurrentApplication : public IApplication {
typedef IApplication
  Inherited;
public:
/*--------------------------------- Arguments --------------------------------*/
virtual int
  argc    ( ) const;

virtual IString
  argv    ( int argumentNumber ) const;

virtual ICurrentApplication
 &setArgs ( int               argc,
            const char* const argv[] );

/*---------------------------- Resource Libraries ----------------------------*/
virtual IResourceLibrary
 &userResourceLibrary    ( ) const,
 &resourceLibrary        ( ) const;

virtual ICurrentApplication
 &setUserResourceLibrary ( const char*                          resLibName,
                           IDynamicLinkLibrary::ESearchLocation searchLocation =
                                    IDynamicLinkLibrary::kOSDefaultSearch),
 &setResourceLibrary     ( const char* resLibName,
                           IDynamicLinkLibrary::ESearchLocation searchLocation =
                                    IDynamicLinkLibrary::kOSDefaultSearch);


/*---------------------------- Color Map -------------------------------------*/
virtual IColorMap
 &colorMap               ( ) const;

virtual ICurrentApplication
 &adoptColorMap          ( IColorMap* colorMap );

/*--------------------------- Starting and Stopping --------------------------*/
virtual ICurrentApplication
 &run  ( ),
 &exit ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  ICurrentApplication ( );
virtual
 ~ICurrentApplication ( );

/*---------------------------- Process Information ---------------------------*/
#ifdef IC_PM
struct pib_s
 &pib ( );
#endif // IC_PM

private:
/*---------------------------------- Private ---------------------------------*/
friend class IApplication;

IResourceLibrary
 *icluiLib,
 *userLib;
bool
  exeResource;
int
  argCount;
IString
 *argValue;
#ifdef IC_PM
struct pib_s
 *pPIB;
#endif // IC_PM
ICurrentApplicationData
 *pCurrentApplicationData;
IColorMap
 *fColorMap;
}; // ICurrentAppliction


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IAPP_ */
