// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 53 1.4.1.3 source/core/collect/iaorder.h, collection, ioc.v400, 980918 
#ifndef _IAORDER_
#define _IAORDER_

#include <iacllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IOrderedCursor : public IElementCursor <Element> 
{
  typedef  ICursorImpl Implementation;

public:

  bool setToLast        ();

  bool setToPrevious    ();

protected:

           IOrderedCursor   (Implementation*);











};

template <class Element>
class IAOrderedCollection : public virtual IACollection <Element> {

  typedef  IACollectionImpl Implementation;

public:


           IAOrderedCollection
                            (INotifier&);


          ~IAOrderedCollection
                            ();

  Element const&
           elementAtPosition
                            (IPosition) const;

  Element const&
           first            () const;

  bool isFirstAt        (ICursor const&) const;

  bool isLastAt         (ICursor const&) const;

  Element const&
           last             () const;

  IPosition
           positionAt       (ICursor const&) const;




  void     removeAtPosition (IPosition);




  void     removeFirst      ();




  void     removeLast       ();

  bool setToLast        (ICursor&) const;

  void     setToPosition    (IPosition, ICursor&) const;

  bool setToPrevious    (ICursor&) const;

  // for backward compatibility
  Element const&
           firstElement     () const;

  bool isFirst          (ICursor const&) const;

  bool isLast           (ICursor const&) const;

  Element const&
           lastElement      () const;

  IPosition
           position         (ICursor const&) const;

protected:

           IAOrderedCollection
                            ();

           IAOrderedCollection
                            (IAOrderedCollection <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAOrderedCollection <Element> const&);





















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iaorder.inl>


#pragma info (restore)


#endif // _IAORDER_
