// Revision: 23 1.4.1.3 source/ui/extapp/ianimbut.hpp, multimedia, ioc.v400, 980918 
#ifndef _IANIMBUT_
#define _IANIMBUT_
/*******************************************************************************
* FILE NAME: ianimbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAnimatedButton                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icustbut.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IAnimatedButtonData;
class IBitmapHandle;
class ISize;
class IResourceId;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IAnimatedButton : public ICustomButton {
typedef ICustomButton
  Inherited;
public:
class Style;
/*----------------------------- Constructors ---------------------------------*/
  IAnimatedButton  ( unsigned long     id,
                     IWindow*          parent,
                     IWindow*          owner,
                     const IRectangle& initial = IRectangle(),
                     const Style&      style = defaultStyle() );

  IAnimatedButton  ( const IWindowHandle& handle );

virtual
  ~IAnimatedButton ( );

/*-------------------------------- Styles ------------------------------------*/
INESTEDBITFLAGCLASSDEF4(Style, IAnimatedButton, IWindow,
                        IControl, IButton, ICustomButton);

static const Style
  IC_IMPORTU animateWhenLatched,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------ Animated Bitmap Identifiers -----------------------*/
enum AnimatedBitmaps {
  rewind,
  stop,
  pause,
  play,
  fastForward,
  record,
  mute,
  trackAdvance,
  trackReverse,
  stepForward,
  stepBackward,
  scanForward,
  scanBackward,
  eject,
  volumeUp,
  volumeDown
};

/*------------------------------ Bitmaps -------------------------------------*/
virtual IAnimatedButton
 &setBitmaps   ( const IResourceId& firstBitmap,
                 unsigned long      count ),
 &setBitmaps   ( AnimatedBitmaps    bitmaps );

virtual IBitmapHandle
  bitmap       ( unsigned long index = 0 ) const;

virtual unsigned long
  bitmapCount        ( ) const,
  currentBitmapIndex ( ) const;

virtual IAnimatedButton
 &setCurrentBitmapIndex ( unsigned long index = 0 );

/*-------------------------------- Animation ---------------------------------*/
unsigned long
  animationRate       ( ) const;

virtual IAnimatedButton
 &setAnimationRate    ( unsigned long newRate = 1000 ),
 &startAnimation      ( unsigned long index = 0 ),
 &stopAnimation       ( );

bool
  isAnimationStarted    ( ) const,
  isAnimatedWhenLatched ( ) const;

virtual IAnimatedButton
 &enableAnimateWhenLatched  ( bool enable = true ),
 &disableAnimateWhenLatched ( ),
 &latch                     ( bool latched = true,
                              bool refresh = true );

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
  IAnimatedButton            (const IAnimatedButton&);
  IAnimatedButton& operator= (const IAnimatedButton&);
static Style
  fgCurrentDefaultStyle;
IAnimatedButtonData
 *fAnimatedButtonData;
};

INESTEDBITFLAGCLASSFUNCS(Style, IAnimatedButton)

#endif /* IC_PMWIN */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IANIMBUT_ */
