// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 51 1.4.1.3 source/core/collect/iamwt.h, collection, ioc.v400, 980918 
#ifndef _IAMWT_
#define _IAMWT_

#include <iatree.h>
#include <iimwt.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <INumber numOfChildren, class Element>
class IAMultiwayTree : public IATree <Element> 
{
  typedef  IMultiwayTreeImpl Implementation;

public:

  void     attachAsChild    (ITreeCursor const&, IPosition,
                             IAMultiwayTree
                              <numOfChildren, Element> const&);

  void     attachAsRoot     (IAMultiwayTree
                              <numOfChildren, Element> const&);

  void     attachSubtreeAsChild
                            (ITreeCursor const&, IPosition,
                             IAMultiwayTree
                              <numOfChildren, Element> const&,
                             ITreeCursor const&);

  void     attachSubtreeAsRoot
                            (IAMultiwayTree
                              <numOfChildren, Element> const&,
                             ITreeCursor const&);

  void     copy             (IAMultiwayTree
                              <numOfChildren, Element> const&);

  void     copySubtree      (IAMultiwayTree
                              <numOfChildren, Element> const&,
                             ITreeCursor const&);

  bool hasChild         (IPosition, ITreeCursor const&) const;

  INumber  numberOfChildren () const;

protected:

           IAMultiwayTree   ();

           IAMultiwayTree   (IAMultiwayTree
                              <numOfChildren, Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAMultiwayTree
                              <numOfChildren, Element> const&);














};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iamwt.inl>


#pragma info (restore)


#endif // _IAMWT_
