// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 49 1.5.1.3 source/core/collect/iamap.h, collection, ioc.v400, 980918 
#ifndef _IAMAP_
#define _IAMAP_

#include <iaeqkey.h>
#include <iiamap.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IAMap :
  public IAEqualityKeyCollection <Element, Key> {

  typedef  IAEqualityKeyCollection <Element, Key> Inherited;

  typedef  IAMapImpl Implementation;

public:


           IAMap
                            (INotifier&);


          ~IAMap
                            ();




  void     addDifference    (IAMap <Element, Key> const&,
                             IAMap <Element, Key> const&); 




  void     addIntersection  (IAMap <Element, Key> const&,
                             IAMap <Element, Key> const&);




  void     addUnion         (IAMap <Element, Key> const&,
                             IAMap <Element, Key> const&);




  void     differenceWith   (IAMap <Element, Key> const&);




  void     intersectionWith (IAMap <Element, Key> const&);




  void     unionWith        (IAMap <Element, Key> const&);

  bool     operator==       (IAMap
                              <Element, Key> const&) const;

  bool     operator!=       (IAMap
                              <Element, Key> const&) const;

protected:

           IAMap
                            ();

           IAMap
                            (IAMap <Element, Key> const&);

  bool     locateNext       (Element const&, ICursor&) const;

  bool     locateNextElementWithKey
                            (Key const&, ICursor&) const;

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

  INumber  removeAllElementsWithKey
                            (Key const&);

  bool     setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IAMap <Element, Key> const&);













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iamap.inl>






#pragma info (restore)


#endif // _IAMAP_
