// Revision: 03 1.8 source/ui/basectl/ialgnatt.hpp, canvas, ioc.v400, 980918 
#ifndef _IALGNATT_
  #define _IALGNATT_
/*******************************************************************************
* FILE NAME: ialgnatt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAlignmentAttribute                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iattribt.hpp>
#include <iatname.hpp>

#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IAlignmentAttribute : public IAttribute {
typedef IAttribute
  Inherited;
public:
enum EHorizontalAlignment {
  kLeft,
  kRight,
  kCenter,
  kStretch
  };

enum EVerticalAlignment {
  kTop,
  kBottom,
  kCenterVertical,
  kStretchVertical
  };

/*------------------------------- Constructors -------------------------------*/
  IAlignmentAttribute      ( EHorizontalAlignment horizontalAlignment,
                             EVerticalAlignment verticalAlignment );
  IAlignmentAttribute      ( const IAlignmentAttribute& alignmentAttribute );
virtual
 ~IAlignmentAttribute      ( );

/*------------------------------- Assignment ---------------------------------*/
IAlignmentAttribute
 &operator=                ( const IAlignmentAttribute& alignmentAttribute );

/*------------------------------- Comparison ---------------------------------*/
virtual bool
 operator==                ( const IAttribute& attribute ) const;

/*------------------------------- Alignment ----------------------------------*/
EHorizontalAlignment
 horizontalAlignment       ( ) const;
virtual IAlignmentAttribute
 &setHorizontalAlignment   ( EHorizontalAlignment horizontalAlignment );
EVerticalAlignment
 verticalAlignment         ( ) const;
virtual IAlignmentAttribute
 &setVerticalAlignment     ( EVerticalAlignment verticalAlignment );

/*--------------------------------- Clone ------------------------------------*/
virtual IAttribute
 *clone                    ( ) const; // in lieu of ::Copy()

private:
EHorizontalAlignment       fHorizontalAlignment;
EVerticalAlignment         fVerticalAlignment;

}; // IAlignmentAttribute

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IALGNATT_ */
