// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 46 1.5.1.3 source/core/collect/iakss.h, collection, ioc.v400, 980918 
#ifndef _IAKSS_
#define _IAKSS_

#include <iaksrt.h>
#include <iiakss.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IAKeySortedSet :
  public IAKeySortedCollection <Element, Key> {

  typedef  IAKeySortedCollection <Element, Key> Inherited;

  typedef  IAKeySortedSetImpl Implementation;

public:


           IAKeySortedSet
                            (INotifier&);


          ~IAKeySortedSet
                            ();

  long     compare          (IAKeySortedSet <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
protected:

           IAKeySortedSet
                            ();

           IAKeySortedSet
                            (IAKeySortedSet <Element, Key> const&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  removeAllElementsWithKey
                            (Key const&);

  bool     setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IAKeySortedSet <Element, Key> const&);












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iakss.inl>






#pragma info (restore)


#endif // _IAKSS_
