// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 41 1.4.1.3 source/core/collect/iaksb.h, collection, ioc.v400, 980918 
#ifndef _IAKSB_
#define _IAKSB_

#include <iaksrt.h>
#include <iiaksb.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IAKeySortedBag :
  public IAKeySortedCollection <Element, Key> {

  typedef  IAKeySortedCollection <Element, Key> Inherited;

  typedef  IAKeySortedBagImpl Implementation;

public:


           IAKeySortedBag
                            (INotifier&);


          ~IAKeySortedBag
                            ();

  long     compare          (IAKeySortedBag <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
protected:

           IAKeySortedBag
                            ();

           IAKeySortedBag
                            (IAKeySortedBag <Element, Key> const&);

private:

  static
  Implementation&
           ImplOf           (IAKeySortedBag <Element, Key> const&);












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaksb.inl>






#pragma info (restore)


#endif // _IAKSB_
