// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 39 1.5.1.3 source/core/collect/iaks.h, collection, ioc.v400, 980918 
#ifndef _IAKS_
#define _IAKS_

#include <iakey.h>
#include <iiaks.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IAKeySet :
  public IAKeyCollection <Element, Key> {

  typedef  IAKeyCollection <Element, Key> Inherited;

  typedef  IAKeySetImpl Implementation;

public:


           IAKeySet
                            (INotifier&);


          ~IAKeySet
                            ();

protected:

           IAKeySet
                            ();

           IAKeySet
                            (IAKeySet <Element, Key> const&);

  bool     locateNextElementWithKey
                            (Key const&, ICursor&) const;

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  removeAllElementsWithKey
                            (Key const&);

  bool     setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IAKeySet <Element, Key> const&);









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaks.inl>






#pragma info (restore)


#endif // _IAKS_
