// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 35 1.4.1.3 source/core/collect/iakey.h, collection, ioc.v400, 980918 
#ifndef _IAKEY_
#define _IAKEY_

#include <iacllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IAKeyCollection : public virtual IACollection <Element> 
{
  typedef  IACollectionImpl Implementation;

public:


           IAKeyCollection  (INotifier&);


          ~IAKeyCollection  ();




  bool addOrReplaceElementWithKey
                            (Element const&);




  bool addOrReplaceElementWithKey
                            (Element const&, ICursor&);

  bool containsAllKeysFrom
                            (IACollection <Element> const&) const; 

  bool containsElementWithKey
                            (Key const&) const;

  Element& elementWithKey   (Key const&);

  Element const&
           elementWithKey   (Key const&) const;

  Key const&
           key              (Element const&) const;

  bool locateElementWithKey
                            (Key const&, ICursor&) const;

  bool locateNextElementWithKey
                            (Key const&, ICursor&) const;




  bool locateOrAddElementWithKey
                            (Element const&);




  bool locateOrAddElementWithKey
                            (Element const&, ICursor&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;




  INumber  removeAllElementsWithKey
                            (Key const&);




  bool removeElementWithKey
                            (Key const&);




  bool replaceElementWithKey
                            (Element const&);




  bool replaceElementWithKey
                            (Element const&, ICursor&);

  bool setToNextWithDifferentKey
                            (ICursor&) const;

protected:

           IAKeyCollection  ();

           IAKeyCollection  (IAKeyCollection <Element, Key> const&);

private:

  static
  Implementation&
           ImplOf           (IAKeyCollection <Element, Key> const&);










































};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iakey.inl>


#pragma info (restore)


#endif // _IAKEY_
