// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 28 1.5.1.3 source/core/collect/iaes.h, collection, ioc.v400, 980918 
#ifndef _IAES_
#define _IAES_

#include <iasqntl.h>
#include <iaequal.h>
#include <iiaes.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IAEqualitySequence :
  public IAEqualityCollection <Element>,
  public IASequentialCollection <Element> {

  typedef  IASequentialCollection <Element> Inherited;

  typedef  IAEqualitySequenceImpl Implementation;

public:


           IAEqualitySequence
                            (INotifier&);


          ~IAEqualitySequence
                            ();

  long     compare          (IAEqualitySequence <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  bool     locateFirst      (Element const&, ICursor&) const;

  bool     locateLast       (Element const&, ICursor&) const;

  bool     locatePrevious   (Element const&, ICursor&) const;

  bool     operator==       (IAEqualitySequence
                              <Element> const&) const;

  bool     operator!=       (IAEqualitySequence
                              <Element> const&) const;

protected:

           IAEqualitySequence
                            ();

           IAEqualitySequence
                            (IAEqualitySequence <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAEqualitySequence <Element> const&);



















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaes.inl>






#pragma info (restore)


#endif // _IAES_
