// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 26 1.4.1.3 source/core/collect/iaequal.h, collection, ioc.v400, 980918 
#ifndef _IAEQUAL_
#define _IAEQUAL_

#include <iacllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IAEqualityCollection : public virtual IACollection <Element>
{
  typedef  IACollectionImpl Implementation;

public:


           IAEqualityCollection
                            (INotifier&);


          ~IAEqualityCollection
                            ();

  bool contains         (Element const&) const;

  bool containsAllFrom  (IACollection <Element> const&) const;

  bool locate           (Element const&, ICursor&) const;




  bool locateOrAdd      (Element const&);




  bool locateOrAdd      (Element const&, ICursor&);

  bool locateNext       (Element const&, ICursor&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;




  bool remove           (Element const&);




  INumber  removeAllOccurrences
                            (Element const&);

protected:

           IAEqualityCollection
                            ();

           IAEqualityCollection
                            (IAEqualityCollection <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAEqualityCollection <Element> const&);



















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iaequal.inl>


#pragma info (restore)


#endif // _IAEQUAL_
