// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 17 1.4.1.3 source/core/collect/iadqu.h, collection, ioc.v400, 980918 
#ifndef _IADQU_
#define _IADQU_

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaseq.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IADeque :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:


           IADeque
                            (INotifier&);


          ~IADeque
                            ();




  void     addAsFirst       (Element const&);




  void     addAsFirst       (Element const&, ICursor&);




  void     addAsLast        (Element const&);




  void     addAsLast        (Element const&, ICursor&);

  long     compare          (IADeque <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     removeFirst      ();




  void     removeLast       ();

protected:

           IADeque
                            ();

           IADeque
                            (IADeque <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IADeque <Element> const&);

















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iadqu.inl>






#pragma info (restore)


#endif // _IADQU_
