// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 14 1.6.1.3 source/core/collect/iacllct.h, collection, ioc.v400, 980918 
#ifndef _IACLLCT_
#define _IACLLCT_

#include <ibcllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)


template <class Element>
class ICollectionGuard {
public:
  ICollectionGuard (IACollection<Element>&, long timeout=-1);

  ~ICollectionGuard ();

private:
  IACollection<Element>& ivCollection;

  ICollectionGuard (const ICollectionGuard<Element>&);

         ICollectionGuard<Element>
          &operator=      (const ICollectionGuard<Element>&);











};


template <class Element>
class IElementCursor : public ICursor {

  typedef  ICursorImpl Implementation;

public:

  Element const&
           element          () const;

protected:

           IElementCursor   (Implementation*);










};

template <class Element>
class IACollection : protected IACollectionBase {

  typedef  IACollectionImpl Implementation;

public:


           IACollection     (INotifier&);


  virtual ~IACollection     ();




  bool add              (Element const&);




  bool add              (Element const&, ICursor&);




  void     addAllFrom       (IACollection <Element> const&);

  bool allElementsDo    (bool (*applicatorFunction)
                              (Element&, void*),
                             void* additionalArgument = 0);

  bool allElementsDo    (bool (*applicatorFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0) const;

  bool allElementsDo    (IApplicator <Element>&);

  bool allElementsDo    (IConstantApplicator <Element>&) const;

  Element const&
           any              () const;




  void     copy             (IACollection <Element> const&);


  INotifier&
           disableNotification
                            ();



  Element& elementAt        (ICursor const&);

  Element const&
           elementAt        (ICursor const&) const;


  INotifier&
           enableNotification
                            (bool = true);


  bool isBounded        () const;

  bool isConsistent     () const;

  bool isEmpty          () const;


  bool isEnabledForNotification
                            () const;


  bool isFull           () const;

  INumber  maxNumberOfElements
                            () const;




  ICursor* newCursor        () const;






  INotifier&
           notifier         ();

  INotifier const&
           notifier         () const;

  INotifier&
           notifyObservers  (INotificationEvent const&);


  INumber  numberOfElements () const;




  INumber  removeAll        ();




  INumber  removeAll        (bool (*predicateFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0);




  void     removeAt         (ICursor&);




  void     replaceAt        (ICursor const&, Element const&);

  bool setToFirst       (ICursor&) const;

  bool setToNext        (ICursor&) const;


           operator INotifier&
                            () const;


  // for backward compatibility
  Element const&
           anyElement       () const;

protected:


        friend class ICollectionGuard<Element>;


           IACollection     ();

           IACollection     (IACollection <Element> const&);

  static
  Implementation&
           ImplOf           (IACollection <Element> const&);

private:

#if ! defined (__INO_STREAMING__)
public:



  void   operator<<=      (IDataStream&);




  void   operator>>=      (IDataStream&);

  void   adoptStreamer    (IACollectionStreamer*);
#endif







































};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iacllct.inl>


#pragma info (restore)


#endif // _IACLLCT_
