// Revision: 77 1.8.1.3 source/ui/baseapp/iacceltb.hpp, userinput, ioc.v400, 980918  
#ifndef _IACCELTB_
#define _IACCELTB_
/*******************************************************************************
* FILE NAME: iacceltb.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAcceleratorTable                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IAcceleratorKey;
class IAcceleratorTableCursorData;
class IAcceleratorTableData;
class IAccelTblHandle;
class IResourceId;
class IWindow;
class IWindowHandle;

#pragma enum(4)
#pragma pack(push,4)

class IAcceleratorTable  {
public:
/*------------------------------- Constructors -------------------------------*/
#ifdef IC_PM
  IAcceleratorTable ( bool                     systemQueueKeys );
#endif
  IAcceleratorTable ( const IWindow*           window = 0 );
  IAcceleratorTable ( const IAccelTblHandle&   accelTblHandle );
  IAcceleratorTable ( const IResourceId&       resId );

  IAcceleratorTable ( const IAcceleratorTable& accelTbl );
IAcceleratorTable
 &operator=         ( const IAcceleratorTable& accelTbl );
 ~IAcceleratorTable ( );

/*----------------------------- Handle Management ----------------------------*/
IAccelTblHandle
  handle        ( ) const;
static void
  destroyHandle ( IAccelTblHandle& accelTblHandle );

/*------------------------------- Nested Types -------------------------------*/
class Cursor  {
  public:
  /*------------------------------ Constructors ------------------------------*/
    Cursor ( IAcceleratorTable& accelTbl );
  virtual
   ~Cursor ( );

  /*-------------------------------- Position --------------------------------*/
  virtual bool
    setToFirst ( ),
    setToNext  ( );
  IAcceleratorKey
    element    ( ) const;

  /*------------------------------- Validation -------------------------------*/
  virtual bool
    isValid    ( ) const;
  virtual void
    invalidate ( );

  private:
  /*----------------------------- Hidden Members -----------------------------*/
    Cursor    ( const Cursor& cursor );
  Cursor
   &operator= ( const Cursor& cursor );

  /*-------------------------------- Private ---------------------------------*/
  friend class IAcceleratorTable;
  IAcceleratorTableCursorData
   *fData;
  }; // IAcceleratorTable::Cursor

/*------------------------------ Querying Keys -------------------------------*/
static IAcceleratorKey
  keyAt           ( const Cursor&          cursor );
bool
  containsKeyLike ( const IAcceleratorKey& key ) const,
  locateKeyLike   ( const IAcceleratorKey& key,
                    Cursor&                cursor ) const;
unsigned long
  keyCount        ( ) const;

/*------------------------------ Changing Keys -------------------------------*/
IAcceleratorTable
 &removeKeyAt     ( Cursor&                cursor,
                    bool                   updateWindow = true ),
 &removeAllKeys   ( bool                   updateWindow = true ),
 &replaceKeyAt    ( const Cursor&          cursor,
                    const IAcceleratorKey& newKey,
                    bool                   updateWindow = true );
bool
  addKey          ( const IAcceleratorKey& newKey,
                    bool                   updateWindow = true ),
  addOrReplaceKey ( const IAcceleratorKey& newKey,
                    bool                   updateWindow = true ),
  removeKeyLike   ( const IAcceleratorKey& key,
                    bool                   updateWindow = true );

private:
/*--------------------------------- Private ----------------------------------*/
IAcceleratorTable
 &initialize   ( const IAccelTblHandle& accelTblHandle );
bool
  updateWindow ( );
friend class IAcceleratorList;
friend class IAcceleratorTable::Cursor;
IAcceleratorTableData
 *fData;
}; // IAcceleratorTable

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IACCELTB_
