// Revision: 74 1.7.1.3 source/ui/baseapp/iaccelky.hpp, userinput, ioc.v400, 980918  
#ifndef _IACCELKY_
  #define _IACCELKY_
/*******************************************************************************
* FILE NAME: iaccelky.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAcceleratorKey                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <icmd.hpp>
#include <ikey.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IAcceleratorKeyData;
class IString;
struct _ACCEL;
struct tagACCEL;
#ifdef IC_PM
typedef struct _ACCEL ACCEL;
#endif
#ifdef IC_WIN
typedef struct tagACCEL ACCEL;
#endif
#ifdef IC_MOTIF
struct ACCEL;
#endif

#pragma enum(4)
#pragma pack(push,4)

class IAcceleratorKey  {
public:
/*------------------------------- Constructors -------------------------------*/
  IAcceleratorKey ( IKey::VirtualKey         virtualKey,
                    const IKey::KeyModifier& modifier,
                    ICommand::ActionType     actionType = ICommand::applicationCommand,
                    ICommand::CommandId      commandId = 0 );
  IAcceleratorKey ( const IString&           characterKey,
                    const IKey::KeyModifier& modifier,
                    ICommand::ActionType     actionType = ICommand::applicationCommand,
                    ICommand::CommandId      commandId = 0 );
  IAcceleratorKey ( const ACCEL&             accelerator );
  IAcceleratorKey ( const IAcceleratorKey&   key );
  IAcceleratorKey ( );
IAcceleratorKey
 &operator=       ( const IAcceleratorKey&   key );

 ~IAcceleratorKey ( );

/*------------------------------- Comparisons --------------------------------*/
bool
  operator== ( const IAcceleratorKey& key ) const,
  operator!= ( const IAcceleratorKey& key ) const,
  isLike     ( const IAcceleratorKey& key ) const;
bool
  operator < ( const IAcceleratorKey& key ) const;

/*----------------------------- Key Definitions ------------------------------*/
IAcceleratorKey
 &setKey         ( const IString&           accelKey,
                   const IKey::KeyModifier& modifier = IKey::noModifier ),
 &setKey         ( IKey::VirtualKey         virtualKey,
                   const IKey::KeyModifier& modifier = IKey::noModifier );
IString
  character      ( ) const;
IKey::VirtualKey
  virtualKey     ( ) const;
IKey::KeyModifier
  keyModifier    ( ) const;

/*---------------------------- Action Definitions ----------------------------*/
IAcceleratorKey
 &setCommand       ( ICommand::CommandId commandId ),
 &setSystemCommand ( ICommand::CommandId commandId ),
 &setHelpKey       ( );

ICommand::ActionType
  actionType       ( ) const;

ICommand::CommandId
  commandId        ( ) const;

/*------------------------------- Conversions --------------------------------*/
ACCEL
  asACCEL        ( ) const;

protected:
/*-------------------------------- Identifier --------------------------------*/
static unsigned long
  uniqueKeyFor   ( const IAcceleratorKey& key );

private:
/*--------------------------------- Private ----------------------------------*/
friend unsigned long const
 &key            ( IAcceleratorKey const&   item );
IAcceleratorKey
 &setKeyModifier ( const IKey::KeyModifier& modifier );
IAcceleratorKeyData
 *fData;
};  // IAcceleratorKey

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaccelky.inl>

#endif /* _IACCELKY_ */
