// Revision: 67 1.5.1.4 source/ui/baseapp/iaccel.hpp, userinput, ioc.v400, 980918  
#ifndef _IACCEL_
#define _IACCEL_
/*******************************************************************************
* FILE NAME: iaccel.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IAccelerator                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IAcceleratorData;
class IResourceId;
class IWindow;

#pragma enum(4)
#pragma pack(push,4)

class IAccelerator  {
public:
/*------------------------------- Constructors -------------------------------*/
#ifdef IC_PMWIN
  IAccelerator ( const IAccelTblHandle& haccel = 0,
                 IWindow*               owner  = 0 );
#endif // IC_PMWIN

  IAccelerator ( const IResourceId&     accelResId,
                 IWindow*               owner = 0 );

  IAccelerator ( unsigned long          accelResId,
                 IWindow*               owner = 0 );

 ~IAccelerator ( );


/*---------------------------- Accelerator Tables ----------------------------*/
IAccelerator
 &set    ( const IAccelTblHandle& haccel ),
 &set    ( const IResourceId&     accelResId ),
 &set    ( unsigned long          accelResId );

IAccelerator
 &remove ( ),
 &reset  ( );

bool
  isSet  ( ) const;

IAccelTblHandle
  handle ( ) const;

/*---------------------------------- Window ----------------------------------*/
IWindow
 *owner ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
IAccelerator ( const IAccelerator& accelerator );
IAccelerator
 &operator=  ( const IAccelerator& accelerator );

/*--------------------------------- Private ----------------------------------*/
void
  create      ( IWindow* pwndOwner );
IWindowHandle
  ownerHandle ( ) const;

IWindow
 *pwndClOwner;
IAccelTblHandle
  haccelCl,
  haccelClPrior,
  haccelClOriginal;
bool
  isSetCl;

IAcceleratorData
 *fAcceleratorData;
}; // IAccelerator

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaccel.inl>

#endif /* _IACCEL_ */
