// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 12 1.5.1.4 source/core/collect/iabag.h, collection, ioc.v400, 980918 
#ifndef _IABAG_
#define _IABAG_

#include <iaequal.h>
#include <iiabag.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IABag :
  public IAEqualityCollection <Element> {

  typedef  IAEqualityCollection <Element> Inherited;

  typedef  IABagImpl Implementation;

public:


           IABag
                            (INotifier&);


          ~IABag
                            ();




  void     addDifference    (IABag <Element> const&,
                             IABag <Element> const&); 




  void     addIntersection  (IABag <Element> const&,
                             IABag <Element> const&);




  void     addUnion         (IABag <Element> const&,
                             IABag <Element> const&);




  void     differenceWith   (IABag <Element> const&);




  void     intersectionWith (IABag <Element> const&);

  INumber  numberOfDifferentElements
                            () const;

  bool     setToNextDifferentElement
                            (ICursor&) const;




  void     unionWith        (IABag <Element> const&);

  bool     operator==       (IABag
                              <Element> const&) const;

  bool     operator!=       (IABag
                              <Element> const&) const;

protected:

           IABag
                            ();

           IABag
                            (IABag <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IABag <Element> const&);














};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iabag.inl>






#pragma info (restore)


#endif // _IABAG_
