// Revision: 25 1.4.1.3 source/ui/basectl/i3statbx.hpp, buttonctls, ioc.v400, 980918  
#ifndef _I3STATBX_
#define _I3STATBX_
/*******************************************************************************
* FILE NAME: i3statbx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     I3stateCheckBox                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <isetbut.hpp>
#include <irect.hpp>
#include <ibitflag.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IRectangle;
class ISize;
class IWindowHandle;
class I3StateCheckBoxData;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class I3StateCheckBox : public ISettingButton {
typedef ISettingButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  I3StateCheckBox (unsigned long id,
                   IWindow* parent,
                   IWindow* owner,
                   const IRectangle& initial= IRectangle(),
                   const Style& style = defaultStyle() );

  I3StateCheckBox (unsigned long id,
                   IWindow*      parent);

  I3StateCheckBox (const IWindowHandle& handle);

virtual
  ~I3StateCheckBox( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, I3StateCheckBox,
                                 IWindow, IControl, IButton);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU autoSelect;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;


/*------------------------------- Auto Select --------------------------------*/
virtual I3StateCheckBox
  &enableAutoSelect  (bool enable=true),
  &disableAutoSelect ( );
virtual bool
  isAutoSelect       ( ) const;

/*-------------------------------- Selection ---------------------------------*/
I3StateCheckBox&
  selectHalftone  ( );
bool
  isHalftone      ( ) const;

protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*---------------------------------- Private ---------------------------------*/
#ifdef IC_WIN
friend class I3StateHandler;
#endif

static Style
  currentDefaultStyle;

I3StateCheckBoxData
 *f3StateCheckBoxData;

/*----------------------------- Hidden Functions -----------------------------*/
  I3StateCheckBox  (const I3StateCheckBox&);
  I3StateCheckBox
    &operator=     (const I3StateCheckBox&);
};  // I3StateCheckBox

INESTEDBITFLAGCLASSFUNCS(Style, I3StateCheckBox)

#endif /* IC_PMWIN */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _I3STATBX_ */
