/**
 * FILE NAME: i2dghand.hpp
 *
 * DESCRIPTION:
 *   Declaration of the classes:
 *     IPointerHandle
 *     IPresSpaceHandle
 *     IBitmapHandle
 *     IRegionHandle
 *
 *   IBM Open Class Library
 *   (C) Copyright International Business Machines Corporation,  1997
 *   Licensed Material - Program-Property of IBM - All Rights Reserved.
 */

// Revision: 66 1.14.1.6 source/albert/graph2d/i2dghand.hpp, 2d, ioc.v400, 980918 

#ifndef _I2DGHAND_
#define _I2DGHAND_

#include <ibase.hpp>
#include <ibhandle.hpp>
#include <igraphpl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_MOTIF
class IXDC;
#endif

#ifdef IC_MOTIF
struct _WidgetRec;

typedef _WidgetRec* INativeWindowHandle;
#endif
#ifdef IC_PM
typedef unsigned long INativeWindowHandle;
#endif
#ifdef IC_WIN
typedef void* INativeWindowHandle;
#endif

#pragma pack(push,4)
#pragma enum(4)

class IPointerHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef unsigned long Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IPointerHandle ( Value value=0 );
  IPointerHandle ( const IPointerHandle& aHandle );
 ~IPointerHandle ( );

IPointerHandle
 &operator =     ( const IPointerHandle& aHandle );


/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IPointerHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

protected:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IPointerHandle


class IPresSpaceHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef IXDC* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IPresSpaceHandle ( Value value=0, INativeWindowHandle hwnd=0 );

  IPresSpaceHandle (const IPresSpaceHandle& src);
  IPresSpaceHandle& operator= (const IPresSpaceHandle& src);
  ~IPresSpaceHandle ();

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IPresSpaceHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_PM
friend INativeWindowHandle WindowFromDC(const IPresSpaceHandle&);
#endif
Value
  fhandle;
}; // IPresSpaceHandle

class IBitmapHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef unsigned long Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IBitmapHandle ( Value value=0 );
  IBitmapHandle ( const IBitmapHandle& aHandle );
 ~IBitmapHandle ( );

IBitmapHandle
 &operator =    ( const IBitmapHandle& aHandle );


/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IBitmapHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

protected:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IBitmapHandle


class IRegionHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef void* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IRegionHandle ( Value value=0 );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IRegionHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IRegionHandle


#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <i2dghand.inl>

#endif // _I2DGHAND_
