/*
** Module   :DNSHOOK.CMD
** Abstract :Sample message hook.
**           It handles setting/removing of DNS entries in RESOLV2.
**           To enable script add following entry to the configuration file:
**
** Copyright (C) 1999, 2000  Link Guard Solutions Ltd.
**
** Log: Sun  01/10/2000 Updated
*/

address CMD

/* Handle INIT message */

if arg(1)='MSG_000000F0' then
do
    etc=value('ETC',,'OS2ENVIRONMENT')
    resolv2_file=etc'\resolv2'
    resolv2_backup=etc'\resolv2.sav'
    resolv_file=etc'\resolv'
    resolv_backup=etc'\resolv.sav'

    res=stream(resolv_file, 'c', 'query exists')

    call sf_set_var 'resolv', resolv_file
    call sf_set_var 'resolv.bak', ''

    if res<>'' then
    do
        'copy 'resolv_file resolv_backup '1>nul 2>nul'

        if rc = 0 then
        do
            call sf_set_var 'resolv', res
            call sf_set_var 'resolv.bak', stream(resolv_backup, 'c', 'query exists')
        end
    end

    res=stream(resolv2_file, 'c', 'query exists')

    call sf_set_var 'resolv2', resolv2_file
    call sf_set_var 'resolv2.bak', ''

    if res<>'' then
    do
        'copy 'resolv2_file resolv2_backup '1>nul 2>nul'

        if rc = 0 then
        do
            call sf_set_var 'resolv2', res
            call sf_set_var 'resolv2.bak', stream(resolv2_backup, 'c', 'query exists')
        end
    end

end

/* Handle DONE message */

if arg(1)='MSG_00000004' then
do
    if sf_get_var('resolv.bak', '') <> '' then
    do
        'copy 'sf_get_var('resolv.bak') sf_get_var('resolv') '1>nul 2>nul'
        call sf_syslog log_info, 'file RESOLV restored'
    end
    else
        'del 'sf_get_var('resolv')' 1>nul 2>nul'
    if sf_get_var('resolv2.bak', '') <> '' then
    do
        'copy 'sf_get_var('resolv2.bak') sf_get_var('resolv2') '1>nul 2>nul'
        call sf_syslog log_info, 'file RESOLV2 restored'
    end
    else
        'del 'sf_get_var('resolv2')' 1>nul 2>nul'
end

/* Handle DNS messages */

if (arg(1)='MSG_00000063' | arg(1)='MSG_00000064') then
do
    if sf_get_config("dnshook.cmd", "detectdns") <> 0 then
	    call sf_set_var 'resolv.'||right(arg(1),1), arg(3)

    if sf_get_var('resolv') <> '' then
    do
        rf = sf_get_var('resolv')
        call stream rf, 'c', 'close'
        '@del 'rf' 2>nul'
        domain = sf_get_config("dnshook.cmd", "domain")
        if domain ='' then
            domain = "your.domain.com"

        call lineout rf, "domain "||domain

        /* Write detected servers if any */
        d1 = sf_get_var('resolv.3','')
        if (d1<>'') then
            call lineout rf, "nameserver "||d1

        d2 = sf_get_var('resolv.4','')
        if (d2<>'') then
            call lineout rf, "nameserver "||d2

        /* Write static servers */
        do i = 1 to sf_get_config("dnshook.cmd", "server", 0)
            call lineout rf, "nameserver "||sf_get_config("dnshook.cmd", "server", i)
        end

        call stream rf, 'c', 'close'
/*        call sf_syslog log_info, 'added name server string:''nameserver' arg(3)*/
    end

    if sf_get_var('resolv2') <> '' then
    do
        rf = sf_get_var('resolv2')
        call stream rf, 'c', 'close'
        '@del 'rf' 2>nul'
        if domain<>"<your domain>" | domain='' | domain='DOMAIN' then
            call lineout rf, "domain "||domain

        d1 = sf_get_var('resolv.3','')
        if (d1<>'') then
            call lineout rf, "nameserver "||d1

        d2 = sf_get_var('resolv.4','')
        if (d2<>'') then
            call lineout rf, "nameserver "||d2

        call stream rf, 'c', 'close'
/*        call sf_syslog log_info, 'added name server string:''nameserver' arg(3)*/
    end
end

exit 0
