# Expects several files with shot metadata (date, exposure) inside (eg. EXIF in
# JPEG). Renames them to YYMMDD_HHMMSSeN. Where datetime is retrived from
# metadata of the first file.
# N starts from 1. If this filename already exists next number is used.
# It is allowed to use glob chars in passed file names.

import EXIF, exiftoolpl, getopt, glob, os, sys

def showUsage():
  print "Usage: " + sys.argv[0] + " [-e] [-g] [-p] [-s <seconds>] <files list>\n" +\
        "  -e Exposure sort. Before renaming sort files in exposure order.\n" +\
        "     The common filename prefix is still took from the first file in the\n" +\
        "     commandline.\n" +\
        "  -g Group rename. Files with the same name but diferent extensions\n" +\
        "     will be renamed to the same name as the anchor JPEG.\n" +\
        "  -p exiftool.pl call. Retrieves EXIF via external exiftool.pl tool.\n" +\
        "  -s <seconds> On renaming adds given count of seconds to EXIF date\n" +\
        "     to form file name. The count may be negative."
  sys.exit(0)

# convert date to string that's a legal filename
# "2001:03:31 12:27:36" becomes "010331_122736"
def date2file(d):
    dateStr=str(d)
    if not TIME_SHIFT_SECONDS:
        dateStr=dateStr.replace(' ', '_')
        dateStr=dateStr.replace(':', '')
        dateStr=dateStr[2:len(dateStr)]
    else:
        dateMo = re.match("(\\d\\d\\d\\d):(\\d\\d):(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d)", dateStr)
        if not dateMo:
            print "%s is not parsable date"%(dateStr)
            dateStr=None
        else:
            dateDT = datetime.datetime(int(dateMo.group(1)), int(dateMo.group(2)), int(dateMo.group(3)), int(dateMo.group(4)), int(dateMo.group(5)), int(dateMo.group(6)))
            dateDT = dateDT + datetime.timedelta(0, TIME_SHIFT_SECONDS)
            dateStr = dateDT.strftime("%y%m%d_%H%M%S")

#    print "'%s' converted to '%s'"%(str(d), dateStr)
    return dateStr

def constructFileName(baseName, nameExt, nameInd):
  return baseName + "e" + str(nameInd) + nameExt

def constructPathName(dirName, baseName, nameExt, nameInd):
  return os.path.join(dirName, constructFileName(baseName, nameExt, nameInd))

def getExifTags(fileName):
  tags = {}
  try:
    f = open(fileName, "rb")
    if OPT_USE_EXIFTOOLPL:
      tags = exiftoolpl.process_file(f)
    else:
      tags = EXIF.process_file(f)
    f.close()
  except:
    sys.stderr.write("Error parsing file %s: %s\n"%(fileName, `sys.exc_info()`))
  return tags

class Photo:
  def __init__(self, fileName, exposure):
    self.fileName = fileName
    self.exposure = exposure

  def __repr__(self):
    return self.fileName


def main():
  global TIME_SHIFT_SECONDS, OPT_GROUP_RENAME, OPT_EXPOSURE_SORT, OPT_USE_EXIFTOOLPL

  if len(sys.argv) < 2:
    showUsage()

  # parse options
  try:
    (optList, globList) = getopt.getopt(sys.argv[1:], 'egps:')
  except:
    showUsage()

  if not globList:
    showUsage()

  opts={}
  for (optName, optVal) in optList:
    opts[optName] = optVal

  # group rename mode option
  OPT_EXPOSURE_SORT = opts.has_key('-e')

  # group rename mode option
  OPT_GROUP_RENAME = opts.has_key('-g')

  # exiftool call option
  OPT_USE_EXIFTOOLPL = opts.has_key('-p')

  # time shift option
  optTimeShiftStr = opts.get('-s')
  if optTimeShiftStr:
      TIME_SHIFT_SECONDS = int(optTimeShiftStr)

  filesList = []
  for globName in globList:
    globExpanded = glob.glob(globName)
    if not globExpanded:
      print "File name %s is not found"%(globName)
      continue # just warning
    filesList.extend(globExpanded)

  dateTagName = "EXIF DateTimeOriginal"
  infoFileName = filesList[0]

  if not OPT_EXPOSURE_SORT:
    # parse only for date
    dateTagValue = getExifTags(infoFileName).get(dateTagName)
  else:
    # read info from all files
    photos = []
    for fileNameInd in range(len(filesList)):
      fileName = filesList[fileNameInd]
      tags = getExifTags(fileName)
      if not tags:
        continue # parse error or empty EXIF list

      # read date only from the first file
      if fileNameInd == 0:
        dateTagValue = tags.get(dateTagName)
      photos.append(Photo(fileName, EXIF.effectiveExposure(tags)))

    photos.sort(key=lambda a:a.exposure) # sort in exposure order

    # and replace filesList with sorted one
    filesList = map((lambda a:a.fileName), photos)

  # all necessary EXIF info has been read
  if not dateTagValue:
    print "%s doesn't contain creation date"%(infoFileName)
    return

  newNamePrefix = date2file(dateTagValue)
  if not newNamePrefix:
    print "Failed to generate file name based on date %s"%(dateTagVal)
    return

  # new filename prefix is generated. We can start to rename
  nameInd = 0
  for filePath in filesList:
    (fileDir, fileNameFull) = os.path.split(filePath)
    (fileName, fileExt) = os.path.splitext(fileNameFull)

    if OPT_GROUP_RENAME:
        # take all names which differ only by extension. Calling glob()
        # also handles case sensitivity platform issues
        pathesOld = glob.glob(os.path.join(fileDir, fileName + ".*"))
        # and not forget filename without an extension. This may be even original file
        # pathesOld.extend() doesn't work because glob() returns R/O list
        pathesOld = pathesOld + glob.glob(os.path.join(fileDir, fileName))
    else:
        # no actual group handling. Create trivial group with only original name
        pathesOld = [filePath]

    exts = []
    for pathOld in pathesOld:
      (tmpName, tmpExt) = os.path.splitext(pathOld)
      exts.append(tmpExt)

    forceStop = False
    while True: # search for free index. Assume that int type width is enough :)
      nameInd += 1

      # check only name to avoid problem when dir ends with multiple slashes
      anchorNameFull = constructFileName(newNamePrefix, fileExt, nameInd)
      if anchorNameFull == fileNameFull:
        # current candidate has the same name as the original file so we can
        # leave it as is
        print "Rename of %s is skipped because new name is the same"%(fileNameFull)
        break

      nameIndIsUsed = False
      for ext in exts:
        newPath = constructPathName(fileDir, newNamePrefix, ext, nameInd)
        if os.access(newPath, os.F_OK):
          nameIndIsUsed = True
          break

      if nameIndIsUsed:
        continue # index is already occupied, try next value

      # index is accepted. Perform actual rename
      oldBase = os.path.join(fileDir, fileName)
      for ext in exts:
        oldPath = oldBase + ext
        newPath = constructPathName(fileDir, newNamePrefix, ext, nameInd)
        try:
          os.rename(oldPath, newPath)
        except OSError, exc:
          print "Rename of %s to %s is failed: %s"%(filePath, newPath, str(exc))
          forceStop = True # this is abnormal to have rename errors so we stop completely to not break series
          break

      break # end of check anyway

    if forceStop:
      break

  print "Rename completed"

TIME_SHIFT_SECONDS = 0
OPT_GROUP_RENAME = False
OPT_EXPOSURE_SORT = False
OPT_USE_EXIFTOOLPL = False
main()
