#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Wrapper to exiftool.pl/exiftool.exe to extract EXIF information in digital
# camera image files. It is written to be at least similar as possible to EXIF
# module and outputs tags with the same name as EXIF does.
#
# To use this library call with:
#    f=open(path_name, 'rb')
#    tags=exiftoolpl.process_file(f)

import json, subprocess

def process_file(imgFile):
    # call exiftool passing the file to its stdin
    etProcess = subprocess.Popen(["exiftool", "-j", "-g", "-"], stdin=imgFile, stdout=subprocess.PIPE)
    etOut = etProcess.communicate()[0]
    etJson = json.loads(etOut)

    exifTags = {}
    for (exifName, exifVal) in etJson[0]["EXIF"].items():
        # patch name to be compatible with EXIF module
        if exifName == "ISO":
            exifName = "ISOSpeedRatings"

        # value type is lost here and all values are strings but it is fine for now
        exifTags["EXIF " + exifName] = exifVal

    return exifTags


# library test/debug function. Prints tags in the given file
if __name__ == '__main__':
    import sys

    f = open(sys.argv[1], "rb")
    exifTags = process_file(f)
    print `exifTags`

