/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import org.gjt.sp.util.Log;

public abstract class PropertiesBean {
    private final char arraysep;
    private final String root;

    protected PropertiesBean(String root) {
        this(root, ':');
    }

    protected PropertiesBean(String root, char arraysep) {
        if (root == null) {
            throw new IllegalArgumentException("root cannot be null");
        }
        this.root = root;
        this.arraysep = arraysep;
    }

    public void load(Properties p) {
        try {
            PropertyDescriptor[] _props = this.getPropertyDescriptors();
            for (int i = 0; i < _props.length; ++i) {
                Method _set;
                if ("class".equals(_props[i].getName()) || (_set = _props[i].getWriteMethod()) == null) continue;
                String _pname = this.root + "." + _props[i].getName();
                Object _val = p.getProperty(_pname);
                if (_val != null) {
                    _val = this.parse((String)_val, _props[i].getPropertyType());
                }
                try {
                    _set.invoke((Object)this, _val);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    public void save(Properties p) {
        try {
            PropertyDescriptor[] _props = this.getPropertyDescriptors();
            for (int i = 0; i < _props.length; ++i) {
                Method _get;
                if ("class".equals(_props[i].getName()) || (_get = _props[i].getReadMethod()) == null) continue;
                Object _val = _get.invoke((Object)this, new Object[0]);
                String _pname = this.root + "." + _props[i].getName();
                if (_val != null) {
                    p.setProperty(_pname, this.encode(_val));
                    continue;
                }
                p.remove(_pname);
            }
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    public void clean(Properties p) {
        try {
            PropertyDescriptor[] _props = this.getPropertyDescriptors();
            for (int i = 0; i < _props.length; ++i) {
                if ("class".equals(_props[i].getName())) continue;
                String _pname = this.root + "." + _props[i].getName();
                p.remove(_pname);
            }
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() throws IntrospectionException {
        BeanInfo _info = Introspector.getBeanInfo(this.getClass());
        return _info.getPropertyDescriptors();
    }

    private String encode(Object value) {
        Class<?> _class = value.getClass();
        if (_class.isArray()) {
            StringBuilder _val = new StringBuilder();
            int _len = Array.getLength(value);
            for (int i = 0; i < _len; ++i) {
                String _str = this.encode(Array.get(value, i));
                if (_str == null) {
                    return null;
                }
                _val.append(_str);
                if (i >= _len - 1) continue;
                _val.append(this.arraysep);
            }
            return _val.toString();
        }
        if (_class != Boolean.class && _class != Boolean.TYPE && _class != Character.class && _class != Character.TYPE && _class != Double.class && _class != Double.TYPE && _class != Float.class && _class != Float.TYPE && _class != Integer.class && _class != Integer.TYPE && _class != Long.class && _class != Long.TYPE && _class != Short.class && _class != Short.TYPE && _class != String.class) {
            Log.log(7, this, "unsupported type: " + _class.getName());
            return null;
        }
        return value.toString();
    }

    private Object parse(String value, Class<?> _class) {
        Object _ret = null;
        if (_class.isArray()) {
            StringTokenizer st = new StringTokenizer(value, String.valueOf(this.arraysep));
            Class<?> _type = _class.getComponentType();
            _ret = Array.newInstance(_type, st.countTokens());
            int _cnt = st.countTokens();
            for (int i = 0; i < _cnt; ++i) {
                Object _val = this.parse(st.nextToken(), _type);
                if (_val == null) {
                    return null;
                }
                Array.set(_ret, i, _val);
            }
        } else if (_class == Boolean.class || _class == Boolean.TYPE) {
            _ret = Boolean.valueOf(value);
        } else if (_class == Character.class || _class == Character.TYPE) {
            _ret = Character.valueOf(value.charAt(0));
        } else if (_class == Double.class || _class == Double.TYPE) {
            _ret = Double.valueOf(value);
        } else if (_class == Float.class || _class == Float.TYPE) {
            _ret = Float.valueOf(value);
        } else if (_class == Integer.class || _class == Integer.TYPE) {
            _ret = Integer.valueOf(value);
        } else if (_class == Long.class || _class == Long.TYPE) {
            _ret = Long.valueOf(value);
        } else if (_class == Short.class || _class == Short.TYPE) {
            _ret = Short.valueOf(value);
        } else if (_class == String.class) {
            _ret = value;
        } else {
            Log.log(7, this, "unsupported type: " + _class.getName());
        }
        return _ret;
    }
}

