/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;

public class ParserRule {
    public static final int MAJOR_ACTIONS = 255;
    public static final int SEQ = 0;
    public static final int SPAN = 2;
    public static final int MARK_PREVIOUS = 4;
    public static final int MARK_FOLLOWING = 8;
    public static final int EOL_SPAN = 16;
    public static final int ACTION_HINTS = 65280;
    public static final int NO_LINE_BREAK = 512;
    public static final int NO_WORD_BREAK = 1024;
    public static final int IS_ESCAPE = 2048;
    public static final int REGEXP = 8192;
    public static final int END_REGEXP = 16384;
    public static final byte MATCH_TYPE_CONTEXT = -1;
    public static final byte MATCH_TYPE_RULE = -2;
    public static final int AT_LINE_START = 2;
    public static final int AT_WHITESPACE_END = 4;
    public static final int AT_WORD_START = 8;
    public final char[] upHashChar;
    public final char[] upHashChars;
    public final int startPosMatch;
    public final char[] start;
    public final Pattern startRegexp;
    public final int endPosMatch;
    public final char[] end;
    public final Pattern endRegexp;
    public final int action;
    public final byte token;
    public final byte matchType;
    public final ParserRule escapeRule;
    public ParserRuleSet delegate;

    public static ParserRule createSequenceRule(int posMatch, String seq, ParserRuleSet delegate, byte id) {
        return new ParserRule(0, seq.substring(0, 1), posMatch, seq.toCharArray(), null, 0, null, null, delegate, id, -1, null);
    }

    public static ParserRule createRegexpSequenceRule(String hashChar, int posMatch, String seq, ParserRuleSet delegate, byte id, boolean ignoreCase) throws PatternSyntaxException {
        return new ParserRule(8192, hashChar, posMatch, null, Pattern.compile(seq, ignoreCase ? 2 : 0), 0, null, null, delegate, id, -1, null);
    }

    public static ParserRule createRegexpSequenceRule(int posMatch, char[] hashChars, String seq, ParserRuleSet delegate, byte id, boolean ignoreCase) throws PatternSyntaxException {
        return new ParserRule(hashChars, 8192, posMatch, null, Pattern.compile(seq, ignoreCase ? 2 : 0), 0, null, null, delegate, id, -1, null);
    }

    public static ParserRule createSpanRule(int startPosMatch, String start, int endPosMatch, String end, ParserRuleSet delegate, byte id, byte matchType, boolean noLineBreak, boolean noWordBreak, String escape) {
        int ruleAction = 2 | (noLineBreak ? 512 : 0) | (noWordBreak ? 1024 : 0);
        return new ParserRule(ruleAction, start.substring(0, 1), startPosMatch, start.toCharArray(), null, endPosMatch, end.toCharArray(), null, delegate, id, matchType, escape);
    }

    public static ParserRule createRegexpSpanRule(String hashChar, int startPosMatch, String start, int endPosMatch, String end, ParserRuleSet delegate, byte id, byte matchType, boolean noLineBreak, boolean noWordBreak, boolean ignoreCase, String escape, boolean endRegexp) throws PatternSyntaxException {
        char[] endArray;
        Pattern endRegexpPattern;
        int ruleAction = 0x2002 | (noLineBreak ? 512 : 0) | (noWordBreak ? 1024 : 0);
        if (endRegexp) {
            ruleAction |= 0x4000;
            endRegexpPattern = Pattern.compile(end, ignoreCase ? 2 : 0);
            endArray = null;
        } else {
            endRegexpPattern = null;
            endArray = end.toCharArray();
        }
        return new ParserRule(ruleAction, hashChar, startPosMatch, null, Pattern.compile(start, ignoreCase ? 2 : 0), endPosMatch, endArray, endRegexpPattern, delegate, id, matchType, escape);
    }

    public static ParserRule createRegexpSpanRule(int startPosMatch, char[] hashChars, String start, int endPosMatch, String end, ParserRuleSet delegate, byte id, byte matchType, boolean noLineBreak, boolean noWordBreak, boolean ignoreCase, String escape, boolean endRegexp) throws PatternSyntaxException {
        char[] endArray;
        Pattern endRegexpPattern;
        int ruleAction = 0x2002 | (noLineBreak ? 512 : 0) | (noWordBreak ? 1024 : 0);
        if (endRegexp) {
            ruleAction |= 0x4000;
            endRegexpPattern = Pattern.compile(end, ignoreCase ? 2 : 0);
            endArray = null;
        } else {
            endRegexpPattern = null;
            endArray = end.toCharArray();
        }
        return new ParserRule(hashChars, ruleAction, startPosMatch, null, Pattern.compile(start, ignoreCase ? 2 : 0), endPosMatch, endArray, endRegexpPattern, delegate, id, matchType, escape);
    }

    public static ParserRule createEOLSpanRule(int posMatch, String seq, ParserRuleSet delegate, byte id, byte matchType) {
        int ruleAction = 528;
        return new ParserRule(ruleAction, seq.substring(0, 1), posMatch, seq.toCharArray(), null, 0, null, null, delegate, id, matchType, null);
    }

    public static ParserRule createRegexpEOLSpanRule(String hashChar, int posMatch, String seq, ParserRuleSet delegate, byte id, byte matchType, boolean ignoreCase) throws PatternSyntaxException {
        int ruleAction = 8720;
        return new ParserRule(ruleAction, hashChar, posMatch, null, Pattern.compile(seq, ignoreCase ? 2 : 0), 0, null, null, delegate, id, matchType, null);
    }

    public static ParserRule createRegexpEOLSpanRule(int posMatch, char[] hashChars, String seq, ParserRuleSet delegate, byte id, byte matchType, boolean ignoreCase) throws PatternSyntaxException {
        int ruleAction = 8720;
        return new ParserRule(hashChars, ruleAction, posMatch, null, Pattern.compile(seq, ignoreCase ? 2 : 0), 0, null, null, delegate, id, matchType, null);
    }

    public static ParserRule createMarkFollowingRule(int posMatch, String seq, byte id, byte matchType) {
        int ruleAction = 8;
        return new ParserRule(ruleAction, seq.substring(0, 1), posMatch, seq.toCharArray(), null, 0, null, null, null, id, matchType, null);
    }

    public static ParserRule createMarkPreviousRule(int posMatch, String seq, byte id, byte matchType) {
        int ruleAction = 4;
        return new ParserRule(ruleAction, seq.substring(0, 1), posMatch, seq.toCharArray(), null, 0, null, null, null, id, matchType, null);
    }

    public static ParserRule createEscapeRule(String seq) {
        int ruleAction = 2048;
        return new ParserRule(ruleAction, seq.substring(0, 1), 0, seq.toCharArray(), null, 0, null, null, null, 0, -1, null);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName()).append("[action=");
        switch (this.action & 0xFF) {
            case 0: {
                result.append("SEQ");
                break;
            }
            case 2: {
                result.append("SPAN");
                break;
            }
            case 4: {
                result.append("MARK_PREVIOUS");
                break;
            }
            case 8: {
                result.append("MARK_FOLLOWING");
                break;
            }
            case 16: {
                result.append("EOL_SPAN");
                break;
            }
            default: {
                result.append("UNKNOWN");
            }
        }
        int actionHints = this.action & 0xFF00;
        result.append("[matchType=").append(this.matchType == -1 ? "MATCH_TYPE_CONTEXT" : (this.matchType == -2 ? "MATCH_TYPE_RULE" : Token.tokenToString(this.matchType)));
        result.append(",NO_LINE_BREAK=").append((actionHints & 0x200) != 0);
        result.append(",NO_WORD_BREAK=").append((actionHints & 0x400) != 0);
        result.append(",IS_ESCAPE=").append((actionHints & 0x800) != 0);
        result.append(",REGEXP=").append((actionHints & 0x2000) != 0);
        result.append("],upHashChar=").append(new String(this.upHashChar));
        result.append(",upHashChars=").append(Arrays.toString(this.upHashChars));
        result.append(",startPosMatch=");
        result.append("[AT_LINE_START=").append((this.startPosMatch & 2) != 0);
        result.append(",AT_WHITESPACE_END=").append((this.startPosMatch & 4) != 0);
        result.append(",AT_WORD_START=").append((this.startPosMatch & 8) != 0);
        result.append("],start=").append(null == this.start ? null : String.valueOf(this.start));
        result.append(",startRegexp=").append(this.startRegexp);
        result.append(",endPosMatch=");
        result.append("[AT_LINE_START=").append((this.endPosMatch & 2) != 0);
        result.append(",AT_WHITESPACE_END=").append((this.endPosMatch & 4) != 0);
        result.append(",AT_WORD_START=").append((this.endPosMatch & 8) != 0);
        result.append("],end=").append(null == this.end ? null : String.valueOf(this.end));
        result.append(",delegate=").append(this.delegate);
        result.append(",escapeRule=").append(this.escapeRule);
        result.append(",token=").append(Token.tokenToString(this.token)).append(']');
        return result.toString();
    }

    private ParserRule(int action, String hashChar, int startPosMatch, char[] start, Pattern startRegexp, int endPosMatch, char[] end, Pattern endRegexp, ParserRuleSet delegate, byte token, byte matchType, String escape) {
        this.action = action;
        this.upHashChar = null == hashChar ? null : hashChar.toUpperCase().toCharArray();
        this.upHashChars = null;
        this.startPosMatch = startPosMatch;
        this.start = start;
        this.startRegexp = startRegexp;
        this.endPosMatch = endPosMatch;
        this.end = end;
        this.endRegexp = endRegexp;
        this.delegate = delegate;
        this.token = token;
        this.matchType = matchType;
        ParserRule parserRule = this.escapeRule = escape != null && escape.length() > 0 ? ParserRule.createEscapeRule(escape) : null;
        if (this.delegate == null && (action & 0xFF) != 0) {
            this.delegate = ParserRuleSet.getStandardRuleSet(token);
        }
    }

    private ParserRule(char[] hashChars, int action, int startPosMatch, char[] start, Pattern startRegexp, int endPosMatch, char[] end, Pattern endRegexp, ParserRuleSet delegate, byte token, byte matchType, String escape) {
        this.action = action;
        this.upHashChar = null;
        HashSet<Character> hashCharsSet = new HashSet<Character>();
        for (char c : hashChars) {
            hashCharsSet.add(Character.valueOf(Character.toUpperCase(c)));
        }
        this.upHashChars = new char[hashCharsSet.size()];
        int i = 0;
        for (Character c : hashCharsSet) {
            this.upHashChars[i++] = c.charValue();
        }
        Arrays.sort(this.upHashChars);
        this.startPosMatch = startPosMatch;
        this.start = start;
        this.startRegexp = startRegexp;
        this.endPosMatch = endPosMatch;
        this.end = end;
        this.endRegexp = endRegexp;
        this.delegate = delegate;
        this.token = token;
        this.matchType = matchType;
        ParserRule parserRule = this.escapeRule = escape != null && escape.length() > 0 ? ParserRule.createEscapeRule(escape) : null;
        if (this.delegate == null && (action & 0xFF) != 0) {
            this.delegate = ParserRuleSet.getStandardRuleSet(token);
        }
    }
}

