/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.HyperSearchFileNode;
import org.gjt.sp.jedit.search.HyperSearchFolderNode;
import org.gjt.sp.jedit.search.HyperSearchNode;
import org.gjt.sp.jedit.search.HyperSearchOperationNode;
import org.gjt.sp.jedit.search.HyperSearchRequest;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchTreeNodeCallback;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.HtmlUtilities;
import org.gjt.sp.util.SyntaxUtilities;
import org.gjt.sp.util.TaskManager;

public class HyperSearchResults
extends JPanel
implements DefaultFocusComponent {
    public static final String NAME = "hypersearch-results";
    public static final String HIGHLIGHT_PROP = "hypersearch.results.highlight";
    private final View view;
    private final JLabel caption;
    private final JTree resultTree;
    private final DefaultMutableTreeNode resultTreeRoot;
    private final DefaultTreeModel resultTreeModel;
    private final RolloverButton highlight;
    private final RolloverButton clear;
    private final RolloverButton multi;
    private final RolloverButton stop;
    private boolean multiStatus;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;

    public HyperSearchResults(View view) {
        super(new BorderLayout());
        this.view = view;
        this.caption = new JLabel();
        Box toolBar = new Box(0);
        toolBar.add(this.caption);
        toolBar.add(Box.createGlue());
        ActionHandler ah = new ActionHandler();
        this.highlight = new RolloverButton();
        this.highlight.setToolTipText(jEdit.getProperty("hypersearch-results.highlight.label"));
        this.highlight.addActionListener(ah);
        toolBar.add(this.highlight);
        this.clear = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.clear.icon")));
        this.clear.setToolTipText(jEdit.getProperty("hypersearch-results.clear.label"));
        this.clear.addActionListener(ah);
        toolBar.add(this.clear);
        this.multi = new RolloverButton();
        this.multi.setToolTipText(jEdit.getProperty("hypersearch-results.multi.label"));
        this.multi.addActionListener(ah);
        toolBar.add(this.multi);
        this.stop = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.stop.icon")));
        this.stop.setToolTipText(jEdit.getProperty("hypersearch-results.stop.label"));
        this.stop.addActionListener(ah);
        toolBar.add(this.stop);
        this.stop.setEnabled(false);
        this.add("North", toolBar);
        this.resultTreeRoot = new DefaultMutableTreeNode();
        this.resultTreeModel = new DefaultTreeModel(this.resultTreeRoot);
        this.resultTree = new HighlightingTree(this.resultTreeModel);
        this.resultTree.setToolTipText(null);
        this.resultTree.setCellRenderer(new ResultCellRenderer());
        this.resultTree.setVisibleRowCount(16);
        this.resultTree.setRootVisible(false);
        this.resultTree.setShowsRootHandles(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.resultTree.getInputMap().remove(keyStroke);
        if (!OperatingSystem.isMacOSLF()) {
            this.resultTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.resultTree.setEditable(false);
        this.resultTree.addKeyListener(new KeyHandler());
        this.resultTree.addMouseListener(new MouseHandler());
        JScrollPane scrollPane = new JScrollPane(this.resultTree);
        Dimension dim = scrollPane.getPreferredSize();
        dim.width = 400;
        scrollPane.setPreferredSize(dim);
        this.add("Center", scrollPane);
        this.resultTree.setTransferHandler(new ResultTreeTransferHandler());
    }

    @Override
    public void focusOnDefaultComponent() {
        this.resultTree.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
        this.multiStatus = jEdit.getBooleanProperty("hypersearch-results.multi");
        this.updateHighlightStatus();
        this.updateMultiStatus();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
        jEdit.setBooleanProperty("hypersearch-results.multi", this.multiStatus);
    }

    private void visitBuffers(final ResultVisitor visitor, final Buffer buffer) {
        HyperSearchResults.traverseNodes(this.resultTreeRoot, new TreeNodeCallbackAdapter(){

            @Override
            public boolean processNode(DefaultMutableTreeNode node) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof HyperSearchResult)) {
                    return true;
                }
                HyperSearchResult result = (HyperSearchResult)userObject;
                if (result.pathEquals(buffer.getSymlinkPath())) {
                    visitor.visit(buffer, result);
                }
                return true;
            }
        });
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bmsg) {
        Buffer buffer = bmsg.getBuffer();
        Object what = bmsg.getWhat();
        if (what == BufferUpdate.LOADED) {
            this.visitBuffers(new BufferLoadedVisitor(), buffer);
        } else if (what == BufferUpdate.CLOSED) {
            this.visitBuffers(new BufferClosedVisitor(), buffer);
        }
    }

    public static boolean traverseNodes(DefaultMutableTreeNode node, HyperSearchTreeNodeCallback callbackInterface) {
        if (!callbackInterface.processNode(node)) {
            return false;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
            if (HyperSearchResults.traverseNodes(childNode, callbackInterface)) continue;
            return false;
        }
        return true;
    }

    public DefaultTreeModel getTreeModel() {
        return this.resultTreeModel;
    }

    public JTree getTree() {
        return this.resultTree;
    }

    public void searchStarted() {
        this.stop.setEnabled(true);
        this.caption.setText(jEdit.getProperty("hypersearch-results.searching", new String[]{HyperSearchResults.trimSearchString()}));
    }

    public void setSearchStatus(String status) {
        this.caption.setText(status);
    }

    public void searchFailed() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.no-results", new String[]{HyperSearchResults.trimSearchString()}));
        for (int i = 0; i < this.resultTreeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            this.resultTree.collapsePath(new TreePath(new Object[]{this.resultTreeRoot, node}));
        }
    }

    public void searchDone(final DefaultMutableTreeNode searchNode, final DefaultMutableTreeNode selectNode) {
        this.stop.setEnabled(false);
        final int nodeCount = searchNode.getChildCount();
        if (nodeCount < 1) {
            this.searchFailed();
            return;
        }
        this.caption.setText(jEdit.getProperty("hypersearch-results.done", new String[]{HyperSearchResults.trimSearchString()}));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                if (!HyperSearchResults.this.multiStatus) {
                    for (i = 0; i < HyperSearchResults.this.resultTreeRoot.getChildCount(); ++i) {
                        HyperSearchResults.this.resultTreeRoot.remove(0);
                    }
                }
                HyperSearchResults.this.resultTreeRoot.add(searchNode);
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
                for (i = 0; i < nodeCount; ++i) {
                    TreePath lastNode = new TreePath(((DefaultMutableTreeNode)searchNode.getChildAt(i)).getPath());
                    HyperSearchResults.this.resultTree.expandPath(lastNode);
                }
                TreePath treePath = selectNode == null ? new TreePath(new Object[]{HyperSearchResults.this.resultTreeRoot, searchNode}) : new TreePath(selectNode.getPath());
                HyperSearchResults.this.resultTree.setSelectionPath(treePath);
                HyperSearchResults.this.resultTree.scrollPathToVisible(treePath);
            }
        });
    }

    public void searchDone(DefaultMutableTreeNode searchNode) {
        this.searchDone(searchNode, null);
    }

    private void updateHighlightStatus() {
        String prop = jEdit.getProperty(HIGHLIGHT_PROP);
        if (prop != null && !prop.isEmpty()) {
            this.highlight.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.match.highlight.icon")));
        } else {
            this.highlight.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.match.normal.icon")));
        }
        this.resultTree.repaint();
    }

    private void updateMultiStatus() {
        if (this.multiStatus) {
            this.multi.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.multi.multiple.icon")));
        } else {
            this.multi.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.multi.single.icon")));
        }
    }

    private void goToSelectedNode(int mode) {
        TreePath path = this.resultTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object value = node.getUserObject();
        if (node.getParent() != this.resultTreeRoot && value instanceof HyperSearchNode) {
            EditPane pane;
            HyperSearchNode n = (HyperSearchNode)value;
            Buffer buffer = n.getBuffer(this.view);
            if (buffer == null) {
                return;
            }
            switch (mode) {
                case 0: {
                    pane = this.view.goToBuffer(buffer);
                    break;
                }
                case 1: {
                    pane = jEdit.newView(this.view, buffer, false).getEditPane();
                    break;
                }
                case 2: {
                    pane = jEdit.newView(this.view, buffer, true).getEditPane();
                    break;
                }
                case 3: {
                    pane = this.view.splitHorizontally();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad mode: " + mode);
                }
            }
            n.goTo(pane);
        }
    }

    private void removeSelectedNode() {
        TreePath path = this.resultTree.getSelectionPath();
        if (path == null) {
            return;
        }
        MutableTreeNode value = (MutableTreeNode)path.getLastPathComponent();
        if (path.getPathCount() > 1) {
            TreePath parentPath = path.getParentPath();
            MutableTreeNode parent = (MutableTreeNode)parentPath.getLastPathComponent();
            int removingIndex = parent.getIndex(value);
            int nextIndex = removingIndex + 1;
            if (nextIndex < parent.getChildCount()) {
                TreeNode next = parent.getChildAt(nextIndex);
                this.resultTree.setSelectionPath(parentPath.pathByAddingChild(next));
            } else {
                this.resultTree.setSelectionPath(parentPath);
            }
            this.resultTreeModel.removeNodeFromParent(value);
        }
        HyperSearchOperationNode.removeNodeFromCache(value);
        if (this.resultTreeRoot.getChildCount() == 0) {
            this.hideDockable();
        }
    }

    private void removeAllNodes() {
        this.resultTreeRoot.removeAllChildren();
        this.resultTreeModel.reload(this.resultTreeRoot);
        this.setSearchStatus(null);
        this.hideDockable();
    }

    private void hideDockable() {
        this.view.getDockableWindowManager().hideDockableWindow(NAME);
    }

    private static String trimSearchString() {
        String s = SearchAndReplace.getSearchString();
        int length = jEdit.getIntegerProperty("hypersearch.displayQueryLength", 100);
        if (s.length() > length) {
            return s.substring(0, length) + "...";
        }
        return s;
    }

    SyntaxStyle parseHighlightStyle(String style) {
        SyntaxStyle s;
        Font f = this.resultTree != null ? this.resultTree.getFont() : UIManager.getFont("Tree.font");
        try {
            s = SyntaxUtilities.parseStyle(style, f.getFamily(), f.getSize(), true, null);
        }
        catch (Exception e) {
            style = "color:#000000";
            s = SyntaxUtilities.parseStyle(style, f.getFamily(), f.getSize(), true);
        }
        return s;
    }

    public void expandAllNodes(DefaultMutableTreeNode node) {
        HyperSearchResults.traverseNodes(node, new TreeNodeCallbackAdapter(){

            @Override
            public boolean processNode(DefaultMutableTreeNode node) {
                HyperSearchResults.this.resultTree.expandPath(new TreePath(node.getPath()));
                return true;
            }
        });
    }

    static class TreeNodeCallbackAdapter
    implements HyperSearchTreeNodeCallback {
        TreeNodeCallbackAdapter() {
        }

        @Override
        public boolean processNode(DefaultMutableTreeNode node) {
            return false;
        }
    }

    static class BufferClosedVisitor
    implements ResultVisitor {
        BufferClosedVisitor() {
        }

        @Override
        public void visit(Buffer buffer, HyperSearchResult result) {
            result.bufferClosed();
        }
    }

    static class BufferLoadedVisitor
    implements ResultVisitor {
        BufferLoadedVisitor() {
        }

        @Override
        public void visit(Buffer buffer, HyperSearchResult result) {
            result.bufferOpened(buffer);
        }
    }

    static interface ResultVisitor {
        public void visit(Buffer var1, HyperSearchResult var2);
    }

    class ResultTreeTransferHandler
    extends TransferHandler {
        ResultTreeTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            TreePath[] paths = HyperSearchResults.this.resultTree.getSelectionPaths();
            ToStringNodes toStringNodes = new ToStringNodes();
            for (TreePath path : paths) {
                DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                toStringNodes.processNode(operNode);
            }
            StringSelection selection = new StringSelection(toStringNodes.nodesString.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }

    static class ResultCellRenderer
    extends EnhancedTreeCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ResultCellRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new ResultCellRenderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof HyperSearchOperationNode) {
                this.setFont(this.boldFont);
                CountNodes countNodes = new CountNodes();
                HyperSearchResults.traverseNodes(node, countNodes);
                this.setText(jEdit.getProperty("hypersearch-results.result-caption", new Object[]{node.toString(), countNodes.resultCount, countNodes.bufferCount}));
            } else if (node.getUserObject() instanceof HyperSearchFolderNode) {
                this.setFont(this.plainFont);
                this.setText(node.toString() + " (" + node.getChildCount() + " files/folders)");
            } else if (node.getUserObject() instanceof HyperSearchFileNode) {
                this.setFont(this.boldFont);
                HyperSearchFileNode hyperSearchFileNode = (HyperSearchFileNode)node.getUserObject();
                this.setText(jEdit.getProperty("hypersearch-results.file-caption", new Object[]{hyperSearchFileNode, hyperSearchFileNode.getCount(), node.getChildCount()}));
            } else {
                this.setFont(this.plainFont);
            }
        }

        static class CountNodes
        implements HyperSearchTreeNodeCallback {
            int bufferCount;
            int resultCount;

            CountNodes() {
            }

            @Override
            public boolean processNode(DefaultMutableTreeNode node) {
                Object userObject = node.getUserObject();
                if (userObject instanceof HyperSearchFileNode) {
                    this.resultCount += ((HyperSearchFileNode)userObject).getCount();
                    ++this.bufferCount;
                }
                return true;
            }
        }
    }

    class GoToNodeAction
    extends AbstractAction {
        private final int mode;

        GoToNodeAction(String labelProp, int mode) {
            super(jEdit.getProperty(labelProp));
            this.mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.goToSelectedNode(this.mode);
        }
    }

    class TreeDisplayAction
    extends AbstractAction {
        TreeDisplayAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
            boolean curState = menuItem.isSelected();
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HyperSearchOperationNode operNodeObj = (HyperSearchOperationNode)operNode.getUserObject();
            if (curState) {
                operNodeObj.cacheResultNodes(operNode);
            }
            operNode.removeAllChildren();
            if (curState) {
                Exception excp = null;
                try {
                    operNodeObj.insertTreeNodes(HyperSearchResults.this.resultTree, operNode);
                }
                catch (Exception ex) {
                    operNodeObj.restoreFlatNodes(HyperSearchResults.this.resultTree, operNode);
                    menuItem.setSelected(false);
                    excp = ex;
                }
                finally {
                    ((DefaultTreeModel)HyperSearchResults.this.resultTree.getModel()).nodeStructureChanged(operNode);
                    HyperSearchResults.this.expandAllNodes(operNode);
                    HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(operNode.getPath()));
                }
                if (excp != null) {
                    throw new RuntimeException(excp);
                }
            } else {
                operNodeObj.restoreFlatNodes(HyperSearchResults.this.resultTree, operNode);
            }
            operNodeObj.setTreeViewDisplayed(menuItem.isSelected());
        }
    }

    class RedoSearchAction
    extends AbstractAction {
        private final HyperSearchOperationNode hyperSearchOperationNode;

        RedoSearchAction(HyperSearchOperationNode hyperSearchOperationNode) {
            super(jEdit.getProperty("hypersearch-results.redo"));
            this.hyperSearchOperationNode = hyperSearchOperationNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchAndReplace.setSearchString(this.hyperSearchOperationNode.getSearchString());
            SearchAndReplace.setSearchMatcher(this.hyperSearchOperationNode.getSearchMatcher());
            HyperSearchResults.this.removeSelectedNode();
            SearchAndReplace.hyperSearch(HyperSearchResults.this.view, false);
        }
    }

    class CollapseChildTreeNodesAction
    extends AbstractAction {
        CollapseChildTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.collapse-child-nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> e = operNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                HyperSearchResults.this.resultTree.collapsePath(new TreePath(node.getPath()));
            }
            HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(operNode.getPath()));
        }
    }

    static class ToStringNodes
    implements HyperSearchTreeNodeCallback {
        StringBuilder nodesString = new StringBuilder();

        ToStringNodes() {
        }

        @Override
        public boolean processNode(DefaultMutableTreeNode node) {
            Object userObject = node.getUserObject();
            if (userObject instanceof HyperSearchFileNode) {
                this.nodesString.append(((HyperSearchFileNode)userObject).path);
            } else if (userObject instanceof HyperSearchResult) {
                HyperSearchResult hsr = (HyperSearchResult)userObject;
                this.nodesString.append(hsr.buffer == null ? hsr.toString() : hsr.buffer.getLineText(hsr.line));
            } else {
                this.nodesString.append(userObject.toString());
            }
            this.nodesString.append('\n');
            return true;
        }
    }

    class CopyToClipboardAction
    extends AbstractAction {
        CopyToClipboardAction() {
            super(jEdit.getProperty("hypersearch-results.copy-to-clipboard"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            ToStringNodes toStringNodes = new ToStringNodes();
            HyperSearchResults.traverseNodes(operNode, toStringNodes);
            StringSelection selection = new StringSelection(toStringNodes.nodesString.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }

    class ExpandChildTreeNodesAction
    extends AbstractAction {
        ExpandChildTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.expand-child-nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HyperSearchResults.this.expandAllNodes(operNode);
        }
    }

    class NewSearchAction
    extends AbstractAction {
        NewSearchAction() {
            super(jEdit.getProperty("hypersearch-results.new-search"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HyperSearchFolderNode nodeObj = (HyperSearchFolderNode)operNode.getUserObject();
            String glob = "*";
            SearchFileSet dirList = SearchAndReplace.getSearchFileSet();
            if (dirList instanceof DirectoryListSet) {
                glob = ((DirectoryListSet)dirList).getFileFilter();
            }
            SearchAndReplace.setSearchFileSet(new DirectoryListSet(nodeObj.getNodeFile().getAbsolutePath(), glob, true));
            SearchDialog.showSearchDialog(HyperSearchResults.this.view, null, 2);
        }
    }

    class RemoveAllTreeNodesAction
    extends AbstractAction {
        RemoveAllTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.remove-all-nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.removeAllNodes();
        }
    }

    class RemoveTreeNodeAction
    extends AbstractAction {
        RemoveTreeNodeAction() {
            super(jEdit.getProperty("hypersearch-results.remove-node"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.removeSelectedNode();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            TreePath path1 = HyperSearchResults.this.resultTree.getPathForLocation(evt.getX(), evt.getY());
            if (path1 == null) {
                return;
            }
            HyperSearchResults.this.resultTree.setSelectionPath(path1);
            if (GUIUtilities.isPopupTrigger(evt)) {
                this.showPopupMenu(evt);
            } else {
                HyperSearchResults.this.goToSelectedNode(0);
            }
        }

        private void showPopupMenu(MouseEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.popupMenu = new JPopupMenu();
            Object userObj = node.getUserObject();
            if (userObj instanceof HyperSearchFileNode || userObj instanceof HyperSearchResult) {
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open", 0));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-view", 1));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-plain-view", 2));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-split", 3));
            }
            if (!(userObj instanceof HyperSearchFolderNode)) {
                this.popupMenu.add(new RemoveTreeNodeAction());
            }
            this.popupMenu.add(new ExpandChildTreeNodesAction());
            if (userObj instanceof HyperSearchFolderNode || userObj instanceof HyperSearchOperationNode) {
                this.popupMenu.add(new CollapseChildTreeNodesAction());
                if (userObj instanceof HyperSearchFolderNode) {
                    this.popupMenu.add(new NewSearchAction());
                }
            }
            if (userObj instanceof HyperSearchOperationNode) {
                this.popupMenu.add(new JPopupMenu.Separator());
                HyperSearchOperationNode resultNode = (HyperSearchOperationNode)userObj;
                JCheckBoxMenuItem chkItem = new JCheckBoxMenuItem(jEdit.getProperty("hypersearch-results.tree-view"), resultNode.isTreeViewDisplayed());
                chkItem.addActionListener(new TreeDisplayAction());
                this.popupMenu.add(chkItem);
                this.popupMenu.add(new RedoSearchAction((HyperSearchOperationNode)userObj));
            }
            this.popupMenu.add(new CopyToClipboardAction());
            GUIUtilities.showPopupMenu(this.popupMenu, evt.getComponent(), evt.getX(), evt.getY());
            evt.consume();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 32: {
                    HyperSearchResults.this.goToSelectedNode(0);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HyperSearchResults.this.resultTree.requestFocus();
                        }
                    });
                    evt.consume();
                    break;
                }
                case 10: {
                    HyperSearchResults.this.goToSelectedNode(0);
                    evt.consume();
                    break;
                }
                case 127: {
                    HyperSearchResults.this.removeSelectedNode();
                    evt.consume();
                    break;
                }
            }
        }
    }

    class HighlightingTree
    extends JTree {
        private String prop;
        private String styleTag;

        HighlightingTree(DefaultTreeModel model) {
            super(model);
            this.prop = jEdit.getProperty(HyperSearchResults.HIGHLIGHT_PROP);
            if (this.prop != null && !this.prop.isEmpty()) {
                Font f = HyperSearchResults.this.resultTree != null ? HyperSearchResults.this.resultTree.getFont() : UIManager.getFont("Tree.font");
                this.styleTag = HtmlUtilities.style2html(this.prop, f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            String s = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            String newProp = jEdit.getProperty(HyperSearchResults.HIGHLIGHT_PROP);
            if (newProp == null || newProp.isEmpty()) {
                return s;
            }
            for (node = (DefaultMutableTreeNode)value; node != null && !(node.getUserObject() instanceof HyperSearchOperationNode); node = (DefaultMutableTreeNode)node.getParent()) {
            }
            if (node == null) {
                return s;
            }
            if (!newProp.equals(this.prop)) {
                this.prop = newProp;
                Font f = HyperSearchResults.this.resultTree != null ? HyperSearchResults.this.resultTree.getFont() : UIManager.getFont("Tree.font");
                this.styleTag = HtmlUtilities.style2html(this.prop, f);
            }
            SearchMatcher matcher = ((HyperSearchOperationNode)node.getUserObject()).getSearchMatcher();
            int i = s.indexOf(": ");
            i = i > 0 ? (i += 2) : 0;
            SearchMatcher.Match m = null;
            ArrayList<Integer> matches = new ArrayList<Integer>();
            try {
                m = matcher.nextMatch(s.substring(i), true, true, true, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            while (m != null) {
                matches.add(i + m.start);
                matches.add(i + m.end);
                i += m.end;
                try {
                    m = matcher.nextMatch(s.substring(i), true, true, true, false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    m = null;
                }
            }
            return HtmlUtilities.highlightString(s, this.styleTag, matches);
        }
    }

    public class ActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == HyperSearchResults.this.highlight) {
                String prop = jEdit.getProperty(HyperSearchResults.HIGHLIGHT_PROP);
                Font f = HyperSearchResults.this.resultTree != null ? HyperSearchResults.this.resultTree.getFont() : UIManager.getFont("Tree.font");
                SyntaxStyle style = new StyleEditor(jEdit.getActiveView(), HtmlUtilities.parseHighlightStyle(prop, f), "hypersearch").getStyle();
                if (style != null) {
                    jEdit.setProperty(HyperSearchResults.HIGHLIGHT_PROP, GUIUtilities.getStyleString(style));
                }
                HyperSearchResults.this.updateHighlightStatus();
            } else if (source == HyperSearchResults.this.clear) {
                HyperSearchResults.this.removeAllNodes();
            } else if (source == HyperSearchResults.this.multi) {
                HyperSearchResults.this.multiStatus = !HyperSearchResults.this.multiStatus;
                HyperSearchResults.this.updateMultiStatus();
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = HyperSearchResults.this.resultTreeRoot.getChildCount() - 2; i >= 0; --i) {
                        HyperSearchResults.this.resultTreeModel.removeNodeFromParent((MutableTreeNode)HyperSearchResults.this.resultTreeRoot.getChildAt(i));
                    }
                }
            } else if (source == HyperSearchResults.this.stop) {
                TaskManager.instance.cancelTasksByClass(HyperSearchRequest.class);
            }
        }
    }
}

