/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManagerOptionPane
extends AbstractOptionPane {
    private JLabel mirrorLabel;
    private JCheckBox disableObsolete;
    private JRadioButton settingsDir;
    private JCheckBox downloadSource;
    private JCheckBox deleteDownloads;
    private JSpinner cacheForSpinner;
    private SpinnerNumberModel spinnerModel;
    private MirrorModel miraModel;
    private JList miraList;
    private JButton updateMirrors;
    private final JLabel updateStatus = new JLabel();

    public PluginManagerOptionPane() {
        super("plugin-manager");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.mirrorLabel = new JLabel();
        this.updateMirrorLabel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JPanel spinnerPanel = null;
        if (jEdit.getSettingsDirectory() != null) {
            this.settingsDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.settings-dir"));
            this.settingsDir.setToolTipText(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars"));
            int delay = jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 10);
            this.spinnerModel = new SpinnerNumberModel(delay, 0, 240, 5);
            this.cacheForSpinner = new JSpinner(this.spinnerModel);
            spinnerPanel = new JPanel();
            spinnerPanel.setLayout(new BoxLayout(spinnerPanel, 0));
            spinnerPanel.add(new JLabel(jEdit.getProperty("options.plugin-manager.list-cache.minutes")));
            spinnerPanel.add(this.cacheForSpinner);
            spinnerPanel.add(Box.createGlue());
        }
        JRadioButton appDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.app-dir"));
        appDir.setToolTipText(MiscUtilities.constructPath(jEdit.getJEditHome(), "jars"));
        this.miraModel = new MirrorModel();
        this.miraList = new JList(this.miraModel);
        this.miraList.setSelectionModel(new SingleSelectionModel());
        this.add("North", this.mirrorLabel);
        this.add("Center", new JScrollPane(this.miraList));
        buttonPanel.add(Box.createVerticalStrut(6));
        this.updateMirrors = new JButton(jEdit.getProperty("options.plugin-manager.updateMirrors"));
        this.updateMirrors.addActionListener(new ActionHandler());
        this.updateMirrors.setEnabled(false);
        ThreadUtilities.runInBackground(new UpdateMirrorsThread(false));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.updateMirrors);
        if (spinnerPanel != null) {
            panel.add(spinnerPanel);
        }
        panel.add(this.updateStatus);
        panel.setAlignmentX(0.0f);
        buttonPanel.add(panel);
        buttonPanel.add(Box.createVerticalStrut(6));
        this.downloadSource = new JCheckBox(jEdit.getProperty("options.plugin-manager.downloadSource"));
        this.downloadSource.setSelected(jEdit.getBooleanProperty("plugin-manager.downloadSource"));
        this.downloadSource.setAlignmentX(0.0f);
        buttonPanel.add(this.downloadSource);
        this.deleteDownloads = new JCheckBox(jEdit.getProperty("options.plugin-manager.deleteDownloads"));
        this.deleteDownloads.setSelected(jEdit.getBooleanProperty("plugin-manager.deleteDownloads"));
        this.deleteDownloads.setAlignmentX(0.0f);
        buttonPanel.add(this.deleteDownloads);
        this.disableObsolete = new JCheckBox(jEdit.getProperty("options.plugin-manager.disable-obsolete"));
        this.disableObsolete.setSelected(jEdit.getBooleanProperty("plugin-manager.disable-obsolete", true));
        this.disableObsolete.setAlignmentX(0.0f);
        buttonPanel.add(this.disableObsolete);
        buttonPanel.add(Box.createVerticalStrut(6));
        ButtonGroup locGrp = new ButtonGroup();
        if (jEdit.getSettingsDirectory() != null) {
            locGrp.add(this.settingsDir);
        }
        locGrp.add(appDir);
        JPanel locPanel = new JPanel();
        locPanel.setLayout(new BoxLayout(locPanel, 1));
        if (jEdit.getSettingsDirectory() != null) {
            locPanel.add(this.settingsDir);
            locPanel.add(Box.createVerticalStrut(3));
        }
        locPanel.setBorder(new TitledBorder(jEdit.getProperty("options.plugin-manager.location")));
        locPanel.add(appDir);
        locPanel.setAlignmentX(0.0f);
        buttonPanel.add(locPanel);
        buttonPanel.add(Box.createGlue());
        this.add("South", buttonPanel);
        if (jEdit.getBooleanProperty("plugin-manager.installUser") && jEdit.getSettingsDirectory() != null) {
            this.settingsDir.setSelected(true);
        } else {
            appDir.setSelected(true);
        }
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("plugin-manager.installUser", this.settingsDir != null && this.settingsDir.isSelected());
        jEdit.setBooleanProperty("plugin-manager.downloadSource", this.downloadSource.isSelected());
        jEdit.setBooleanProperty("plugin-manager.deleteDownloads", this.deleteDownloads.isSelected());
        jEdit.setIntegerProperty("plugin-manager.list-cache.minutes", this.spinnerModel.getNumber().intValue());
        jEdit.setBooleanProperty("plugin-manager.disable-obsolete", this.disableObsolete.isSelected());
        if (this.miraList.getSelectedIndex() != -1) {
            String currentMirror = this.miraModel.getID(this.miraList.getSelectedIndex());
            String previousMirror = jEdit.getProperty("plugin-manager.mirror.id");
            if (!previousMirror.equals(currentMirror)) {
                jEdit.setProperty("plugin-manager.mirror.id", currentMirror);
                jEdit.setProperty("plugin-manager.mirror.name", (String)this.miraModel.getElementAt(this.miraList.getSelectedIndex()));
                this.updateMirrorLabel();
            }
        }
    }

    private void updateMirrorLabel() {
        String mirrorName;
        String currentMirror = jEdit.getProperty("plugin-manager.mirror.id");
        if (currentMirror.equals("NONE")) {
            mirrorName = "Plugin Central default";
        } else {
            mirrorName = jEdit.getProperty("plugin-manager.mirror.name");
            if (mirrorName == null) {
                mirrorName = currentMirror;
            }
        }
        this.mirrorLabel.setText(jEdit.getProperty("options.plugin-manager.mirror") + ' ' + mirrorName);
    }

    class UpdateMirrorsThread
    extends Task {
        private final boolean download;

        UpdateMirrorsThread(boolean download) {
            this.download = download;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _run() {
            try {
                ArrayList<MirrorList.Mirror> mirrors;
                block5: {
                    this.setStatus(jEdit.getProperty("options.plugin-manager.workthread"));
                    this.setMaximum(3L);
                    this.setValue(0L);
                    mirrors = new ArrayList<MirrorList.Mirror>();
                    try {
                        MirrorList mirrorList = new MirrorList(this.download, this);
                        if (this.download) {
                            this.saveMirrorList(mirrorList.getXml());
                        }
                        mirrors.addAll(mirrorList.getMirrors());
                    }
                    catch (Exception ex) {
                        if (!this.download) break block5;
                        Log.log(9, this, ex);
                        ThreadUtilities.runInDispatchThread(new Runnable(){

                            @Override
                            public void run() {
                                GUIUtilities.error(PluginManagerOptionPane.this, "ioerror", new String[]{ex.toString()});
                            }
                        });
                    }
                }
                ThreadUtilities.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerOptionPane.this.miraModel.setList(mirrors);
                        String id = jEdit.getProperty("plugin-manager.mirror.id");
                        int size = PluginManagerOptionPane.this.miraModel.getSize();
                        for (int i = 0; i < size; ++i) {
                            if (size != 1 && !PluginManagerOptionPane.this.miraModel.getID(i).equals(id)) continue;
                            PluginManagerOptionPane.this.miraList.setSelectedIndex(i);
                            break;
                        }
                        if (size == 0) {
                            PluginManagerOptionPane.this.miraList.clearSelection();
                        }
                    }
                });
                this.setValue(3L);
            }
            catch (Throwable throwable) {
                ThreadUtilities.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerOptionPane.this.updateMirrors.setEnabled(true);
                        PluginManagerOptionPane.this.updateStatus.setText(null);
                    }
                });
                throw throwable;
            }
            ThreadUtilities.runInDispatchThread(new /* invalid duplicate definition of identical inner class */);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveMirrorList(String xml) {
            String settingsDirectory = jEdit.getSettingsDirectory();
            if (settingsDirectory == null) {
                return;
            }
            File mirrorList = new File(MiscUtilities.constructPath(settingsDirectory, "mirrorList.xml"));
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(mirrorList));
                IOUtilities.copyStream(null, new ByteArrayInputStream(xml.getBytes()), out, false);
            }
            catch (IOException e) {
                try {
                    Log.log(9, this, "Unable to write cached mirror list : " + mirrorList);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(out);
                    throw throwable;
                }
                IOUtilities.closeQuietly((Closeable)out);
            }
            IOUtilities.closeQuietly((Closeable)out);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PluginManagerOptionPane.this.updateMirrors.setEnabled(false);
            PluginManagerOptionPane.this.updateStatus.setText(jEdit.getProperty("options.plugin-manager.workthread"));
            ThreadUtilities.runInBackground(new UpdateMirrorsThread(true));
        }
    }

    static class SingleSelectionModel
    extends DefaultListSelectionModel {
        SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }
    }

    static class MirrorModel
    extends AbstractListModel {
        private List<MirrorList.Mirror> mirrors = new ArrayList<MirrorList.Mirror>();

        MirrorModel() {
        }

        public String getID(int index) {
            return this.mirrors.get((int)index).id;
        }

        @Override
        public int getSize() {
            return this.mirrors.size();
        }

        @Override
        public Object getElementAt(int index) {
            MirrorList.Mirror mirror = this.mirrors.get(index);
            if (mirror.id.equals("NONE")) {
                return jEdit.getProperty("options.plugin-manager.none");
            }
            return mirror.continent + ": " + mirror.description + " (" + mirror.location + ')';
        }

        public void setList(List<MirrorList.Mirror> mirrors) {
            this.mirrors = mirrors;
            this.fireContentsChanged(this, 0, mirrors.size() - 1);
        }
    }
}

