/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.SyntaxHiliteOptionPane;

class BrowserColorsModel
extends AbstractTableModel {
    private List<Entry> entries = new ArrayList<Entry>();

    BrowserColorsModel() {
        String glob;
        int i = 0;
        while ((glob = jEdit.getProperty("vfs.browser.colors." + i + ".glob")) != null) {
            this.entries.add(new Entry(glob, jEdit.getColorProperty("vfs.browser.colors." + i + ".color", Color.black)));
            ++i;
        }
    }

    void add() {
        this.entries.add(new Entry("", UIManager.getColor("Tree.foreground")));
        this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
    }

    void remove(int index) {
        this.entries.remove(index);
        this.fireTableRowsDeleted(this.entries.size(), this.entries.size());
    }

    public void moveUp(int index) {
        Entry entry = this.entries.get(index);
        this.entries.remove(index);
        this.entries.add(index - 1, entry);
        this.fireTableRowsUpdated(index - 1, index);
    }

    public void moveDown(int index) {
        Entry entry = this.entries.get(index);
        this.entries.remove(index);
        this.entries.add(index + 1, entry);
        this.fireTableRowsUpdated(index, index + 1);
    }

    void save() {
        int i;
        for (i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            jEdit.setProperty("vfs.browser.colors." + i + ".glob", entry.glob);
            jEdit.setColorProperty("vfs.browser.colors." + i + ".color", entry.color);
        }
        jEdit.unsetProperty("vfs.browser.colors." + i + ".glob");
        jEdit.unsetProperty("vfs.browser.colors." + i + ".color");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Entry entry = this.entries.get(row);
        switch (col) {
            case 0: {
                return entry.glob;
            }
            case 1: {
                return entry.color;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Entry entry = this.entries.get(row);
        if (col == 0) {
            entry.glob = (String)value;
        } else {
            entry.color = (Color)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.browser.colors.glob");
            }
            case 1: {
                return jEdit.getProperty("options.browser.colors.color");
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
        }
        throw new InternalError();
    }

    static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        ColorRenderer() {
            this.setOpaque(true);
            this.setBorder(SyntaxHiliteOptionPane.noFocusBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value != null) {
                this.setBackground((Color)value);
            }
            this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : SyntaxHiliteOptionPane.noFocusBorder);
            return this;
        }
    }

    private static class Entry {
        String glob;
        Color color;

        Entry(String glob, Color color) {
            this.glob = glob;
            this.color = color;
        }
    }
}

