/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.List;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.BracketIndentRule;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.util.StandardUtilities;

public class CloseBracketIndentRule
extends BracketIndentRule {
    private boolean aligned;

    public CloseBracketIndentRule(char closeBracket, boolean aligned) {
        super(TextUtilities.getComplementaryBracket(closeBracket, null), closeBracket);
        this.aligned = aligned;
    }

    @Override
    public void apply(JEditBuffer buffer, int thisLineIndex, int prevLineIndex, int prevPrevLineIndex, List<IndentAction> indentActions) {
        int offset;
        int index = this.aligned ? thisLineIndex : prevLineIndex;
        if (index == -1) {
            return;
        }
        CharSequence lineText = buffer.getLineSegment(index);
        for (offset = lineText.length() - 1; offset >= 0 && lineText.charAt(offset) != this.closeBracket; --offset) {
        }
        if (offset == -1) {
            return;
        }
        int closeCount = this.getBrackets((JEditBuffer)buffer, (int)index).closeCount;
        if (closeCount != 0) {
            AlignBracket alignBracket = new AlignBracket(buffer, index, offset);
            int openLine = alignBracket.getOpenBracketLine();
            if (openLine != -1) {
                int column = alignBracket.getOpenBracketColumn();
                alignBracket.setExtraIndent(this.getBrackets((JEditBuffer)buffer, (int)openLine, (int)0, (int)column).openCount);
            }
            indentActions.add(alignBracket);
        }
    }

    private static class AlignBracket
    implements IndentAction {
        private int line;
        private int offset;
        private int openBracketLine;
        private int openBracketColumn;
        private CharSequence openBracketLineText;
        private int extraIndent;

        public AlignBracket(JEditBuffer buffer, int line, int offset) {
            this.line = line;
            this.offset = offset;
            int openBracketIndex = TextUtilities.findMatchingBracket(buffer, this.line, this.offset);
            if (openBracketIndex == -1) {
                this.openBracketLine = -1;
            } else {
                this.openBracketLine = buffer.getLineOfOffset(openBracketIndex);
                this.openBracketColumn = openBracketIndex - buffer.getLineStartOffset(this.openBracketLine);
                this.openBracketLineText = buffer.getLineSegment(this.openBracketLine);
            }
        }

        public int getExtraIndent() {
            return this.extraIndent;
        }

        public void setExtraIndent(int extraIndent) {
            this.extraIndent = extraIndent;
        }

        public int getOpenBracketColumn() {
            return this.openBracketColumn;
        }

        public int getOpenBracketLine() {
            return this.openBracketLine;
        }

        @Override
        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            if (this.openBracketLineText == null) {
                return newIndent;
            }
            return StandardUtilities.getLeadingWhiteSpaceWidth(this.openBracketLineText, buffer.getTabSize()) + this.extraIndent * buffer.getIndentSize();
        }

        @Override
        public boolean keepChecking() {
            return false;
        }
    }
}

