/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class MultiSelectWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        MultiSelectWidget multiSelect = new MultiSelectWidget(view);
        return multiSelect;
    }

    private static class MultiSelectWidget
    implements Widget {
        private final JLabel multiSelect = new ToolTipLabel();
        private final View view;

        MultiSelectWidget(final View view) {
            this.multiSelect.setHorizontalAlignment(0);
            this.multiSelect.setToolTipText(jEdit.getProperty("view.status.multi-tooltip"));
            this.view = view;
            this.multiSelect.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JEditTextArea textArea = view.getTextArea();
                    if (textArea != null) {
                        textArea.toggleMultipleSelectionEnabled();
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.multiSelect;
        }

        @Override
        public void update() {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                if (textArea.isMultipleSelectionEnabled()) {
                    this.multiSelect.setText("M");
                    this.multiSelect.setEnabled(true);
                } else {
                    this.multiSelect.setText("m");
                    this.multiSelect.setEnabled(false);
                }
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.multiSelect.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(fm.charWidth('m'), fm.charWidth('M')) + 1, fm.getHeight());
            this.multiSelect.setPreferredSize(dim);
            this.multiSelect.setMaximumSize(dim);
        }
    }
}

