/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.UIManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SplashScreen
extends JComponent {
    private final FontMetrics fm;
    private final JWindow win;
    private final Image image;
    private int progress;
    private static final int PROGRESS_HEIGHT = 20;
    private static final int PROGRESS_COUNT = 28;
    private String label;
    private String lastLabel;
    private long firstAdvanceTime = System.currentTimeMillis();
    private long lastAdvanceTime = System.currentTimeMillis();
    private Font defaultFont = new Font("Dialog", 0, 10);
    private Font labelFont = UIManager.getFont("Label.font").deriveFont(9.8f);
    private Color versionColor1 = new Color(55, 55, 55);
    private Color versionColor2 = new Color(255, 255, 255, 50);

    public SplashScreen() {
        GraphicsConfiguration gconf;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setBackground(Color.white);
        this.setFont(this.defaultFont);
        this.fm = this.getFontMetrics(this.defaultFont);
        this.image = this.getToolkit().getImage(this.getClass().getResource("/org/gjt/sp/jedit/icons/splash.png"));
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
        Dimension screen = this.getToolkit().getScreenSize();
        this.win = new JWindow();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice gd = gs[0];
        if (gd != null && (gconf = gd.getDefaultConfiguration()) != null) {
            Rectangle bounds = gconf.getBounds();
            screen = new Dimension(bounds.width, bounds.height);
        }
        Dimension size = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2 + 20);
        this.win.setSize(size);
        this.win.getContentPane().add((Component)this, "Center");
        this.win.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
        this.win.validate();
        this.win.setVisible(true);
    }

    public void dispose() {
        this.win.dispose();
    }

    public synchronized void advance() {
        this.logAdvanceTime(null);
        ++this.progress;
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            Log.log(9, this, ie);
        }
    }

    public synchronized void advance(String label) {
        this.logAdvanceTime(label);
        ++this.progress;
        this.label = label;
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            Log.log(9, this, ie);
        }
    }

    private void logAdvanceTime(String label) {
        long currentTime = System.currentTimeMillis();
        if (this.lastLabel != null) {
            Log.log(1, SplashScreen.class, this.lastLabel + ':' + (currentTime - this.lastAdvanceTime) + "/" + (currentTime - this.firstAdvanceTime) + "ms");
        }
        if (label != null) {
            this.lastLabel = label;
            this.lastAdvanceTime = currentTime;
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
        g.drawImage(this.image, 1, 1, this);
        g.setColor(Color.white);
        g.fillRect(1, this.image.getHeight(this) + 1, (this.win.getWidth() - 2) * this.progress / 28, 20);
        g.setColor(Color.black);
        if (this.label != null) {
            int drawOffsetX = (this.getWidth() - this.fm.stringWidth(this.label)) / 2;
            int drawOffsetY = this.image.getHeight(this) + (20 + this.fm.getAscent() + this.fm.getDescent()) / 2;
            this.paintString(g, this.label, drawOffsetX, drawOffsetY);
        }
        String version = "version " + jEdit.getVersion();
        int drawOffsetX = this.getWidth() / 2 - this.fm.stringWidth(version) / 2;
        int drawOffsetY = this.image.getHeight(this) - this.fm.getDescent() - 2;
        this.paintString(g, version, drawOffsetX, drawOffsetY);
        this.notify();
    }

    private void paintString(Graphics g, String version, int drawOffsetX, int drawOffsetY) {
        g.setFont(this.labelFont);
        g.setColor(this.versionColor1);
        g.drawString(version, drawOffsetX, drawOffsetY);
        g.setColor(this.versionColor2);
        g.drawString(version, drawOffsetX + 1, drawOffsetY + 1);
    }
}

