/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.SplitConfigParser;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class PerspectiveManager {
    private static final String PERSPECTIVE_FILENAME = "perspective";
    private static boolean dirty;
    private static boolean enabled;
    private static SettingsXML perspectiveXML;

    public static boolean isPerspectiveDirty() {
        return dirty;
    }

    public static void setPerspectiveDirty(boolean dirty) {
        PerspectiveManager.dirty = dirty;
    }

    public static boolean isPerspectiveEnabled() {
        return enabled;
    }

    public static void setPerspectiveEnabled(boolean enabled) {
        PerspectiveManager.enabled = enabled;
    }

    public static View loadPerspective(boolean restoreFiles) {
        if (perspectiveXML == null) {
            return null;
        }
        if (!perspectiveXML.fileExists()) {
            return null;
        }
        Log.log(3, PerspectiveManager.class, "Loading " + perspectiveXML);
        PerspectiveHandler handler = new PerspectiveHandler(restoreFiles);
        try {
            perspectiveXML.load(handler);
        }
        catch (IOException e) {
            Log.log(9, PerspectiveManager.class, e);
        }
        return handler.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePerspective(boolean autosave) {
        if (!PerspectiveManager.isPerspectiveEnabled() || !jEdit.isStartupDone()) {
            return;
        }
        if (perspectiveXML == null) {
            return;
        }
        if (jEdit.getBufferCount() == 0) {
            return;
        }
        Buffer[] buffers = jEdit.getBuffers();
        LinkedList<Buffer> savedBuffers = new LinkedList<Buffer>();
        for (Buffer buffer : buffers) {
            if (buffer.isNewFile()) continue;
            savedBuffers.add(buffer);
        }
        if (!autosave) {
            Log.log(3, PerspectiveManager.class, "Saving " + perspectiveXML);
        }
        String lineSep = System.getProperty("line.separator");
        SettingsXML.Saver out = null;
        try {
            out = perspectiveXML.openSaver();
            out.writeXMLDeclaration();
            out.write("<!DOCTYPE PERSPECTIVE SYSTEM \"perspective.dtd\">");
            out.write(lineSep);
            out.write("<PERSPECTIVE>");
            out.write(lineSep);
            for (Buffer buffer : savedBuffers) {
                out.write("<BUFFER AUTORELOAD=\"");
                out.write(buffer.getAutoReload() ? "TRUE" : "FALSE");
                out.write("\" AUTORELOAD_DIALOG=\"");
                out.write(buffer.getAutoReloadDialog() ? "TRUE" : "FALSE");
                out.write("\">");
                out.write(XMLUtilities.charsToEntities(buffer.getPath(), false));
                out.write("</BUFFER>");
                out.write(lineSep);
            }
            View[] views = jEdit.getViews();
            for (int i = 0; i < views.length; ++i) {
                View view = views[i];
                if (view == jEdit.getActiveView() && i != views.length - 1) {
                    View last;
                    views[i] = last = views[views.length - 1];
                    views[views.length - 1] = view;
                    view = last;
                }
                View.ViewConfig config = views[i].getViewConfig();
                out.write("<VIEW PLAIN=\"");
                out.write(config.plainView ? "TRUE" : "FALSE");
                out.write("\">");
                out.write(lineSep);
                if (config.title != null) {
                    out.write(lineSep);
                    out.write("<TITLE>");
                    out.write(XMLUtilities.charsToEntities(config.title, false));
                    out.write("</TITLE>");
                    out.write(lineSep);
                }
                out.write("<PANES>");
                out.write(lineSep);
                out.write(XMLUtilities.charsToEntities(config.splitConfig, false));
                out.write(lineSep);
                out.write("</PANES>");
                out.write(lineSep);
                out.write("<GEOMETRY X=\"");
                out.write(String.valueOf(config.x));
                out.write("\" Y=\"");
                out.write(String.valueOf(config.y));
                out.write("\" WIDTH=\"");
                out.write(String.valueOf(config.width));
                out.write("\" HEIGHT=\"");
                out.write(String.valueOf(config.height));
                out.write("\" EXT_STATE=\"");
                out.write(String.valueOf(config.extState));
                out.write("\" />");
                out.write(lineSep);
                if (config.docking != null) {
                    config.docking.saveLayout(PERSPECTIVE_FILENAME, i);
                }
                out.write("</VIEW>");
                out.write(lineSep);
            }
            out.write("</PERSPECTIVE>");
            out.write(lineSep);
            out.finish();
        }
        catch (IOException io) {
            Log.log(9, PerspectiveManager.class, "Error saving " + perspectiveXML);
            Log.log(9, PerspectiveManager.class, io);
        }
        finally {
            IOUtilities.closeQuietly((Closeable)out);
        }
    }

    static {
        enabled = true;
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            perspectiveXML = new SettingsXML(settingsDirectory, PERSPECTIVE_FILENAME);
        }
    }

    private static class PerspectiveHandler
    extends DefaultHandler {
        View view;
        private StringBuilder charData;
        View.ViewConfig config;
        boolean restoreFiles;
        boolean restoreSplits;
        String autoReload;
        String autoReloadDialog;

        PerspectiveHandler(boolean restoreFiles) {
            this.restoreFiles = restoreFiles;
            this.restoreSplits = jEdit.getBooleanProperty("restore.splits", true);
            this.config = new View.ViewConfig();
            this.charData = new StringBuilder();
            this.config.docking = View.getDockingFrameworkProvider().createDockingLayout();
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return XMLUtilities.findEntity(systemId, "perspective.dtd", this.getClass());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            this.charData.setLength(0);
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.attribute(name, value);
            }
        }

        private void attribute(String aname, String value) {
            if (aname.equals("X")) {
                this.config.x = Integer.parseInt(value);
            } else if (aname.equals("Y")) {
                this.config.y = Integer.parseInt(value);
            } else if (aname.equals("WIDTH")) {
                this.config.width = Integer.parseInt(value);
            } else if (aname.equals("HEIGHT")) {
                this.config.height = Integer.parseInt(value);
            } else if (aname.equals("EXT_STATE")) {
                this.config.extState = Integer.parseInt(value);
            } else if (aname.equals("PLAIN")) {
                this.config.plainView = "TRUE".equals(value);
            } else if (aname.equals("AUTORELOAD")) {
                this.autoReload = value;
            } else if (aname.equals("AUTORELOAD_DIALOG")) {
                this.autoReloadDialog = value;
            }
        }

        public static boolean skipRemote(String uri) {
            String protocol;
            if (jEdit.getBooleanProperty("restore.remote")) {
                return false;
            }
            return MiscUtilities.isURL(uri) && !(protocol = MiscUtilities.getProtocolOfURL(uri)).equals("file");
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if (name.equals("BUFFER")) {
                Buffer restored;
                if (this.restoreFiles && !PerspectiveHandler.skipRemote(this.charData.toString()) && (restored = jEdit.openTemporary(null, null, this.charData.toString(), false)) != null) {
                    if (this.autoReload != null) {
                        restored.setAutoReload("TRUE".equals(this.autoReload));
                    }
                    if (this.autoReloadDialog != null) {
                        restored.setAutoReloadDialog("TRUE".equals(this.autoReloadDialog));
                    }
                    jEdit.commitTemporary(restored);
                }
            } else if (name.equals("PANES")) {
                SplitConfigParser parser = new SplitConfigParser(this.charData.toString());
                parser.setIncludeSplits(this.restoreSplits);
                parser.setIncludeFiles(this.restoreFiles);
                parser.setIncludeRemoteFiles(jEdit.getBooleanProperty("restore.remote"));
                this.config.splitConfig = parser.parse();
            } else if (name.equals("VIEW")) {
                if (this.config.docking != null) {
                    this.config.docking.loadLayout(PerspectiveManager.PERSPECTIVE_FILENAME, jEdit.getViewCount());
                }
                this.view = jEdit.newView(this.view, null, this.config);
                this.config = new View.ViewConfig();
                this.config.docking = View.getDockingFrameworkProvider().createDockingLayout();
            } else if (name.equals("TITLE")) {
                this.config.title = this.charData.toString();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charData.append(ch, start, length);
        }
    }
}

