/*static char *SCCSID = "src/dev/dasd/os2dasd/dmgencb.h, dsdm, basedd, initial 93/10/08";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = DMGENCB.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *	       LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *	       REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *	       RESTRICTED MATERIALS OF IBM
 *	       IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Internal control blocks for OS/2 DASD Mgr
 *
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG	  APAR	 CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  08/04/92  @V51531	  51531  Removable media control
 *  10/14/92  @V55646	  55646  Perfview Read/Write ctr not managed correctly
 *  10/08/93  @V74404	  74404  Add Set DASD Mgr parms IOCTL
 *  07/28/94  @V89787	  89787  Add field for cylinder address of boot rec
 *  10/09/97  @V187707	 187707  Partitioned removable media generic solution
 *  12/02/97  @V189588	 189588  Diff HW reporting diff geometry for removable media
 *
 ****************************************************************************/


/*--------------------------------------------------------------------*/
/*								      */
/* Volume Control Block 					      */
/* -------------------- 					      */
/*								      */
/* This control blocks relates OS/2 logical drive letters (A:, B: C:) */
/* and OS/2 physical drive numbers (0, 1, 80h...9fh) to a unit	      */
/* control block.						      */
/*								      */
/*--------------------------------------------------------------------*/


typedef struct _VolumeControlBlock
{
  NPVOLCB     pNextVolCB;		/* Next Volume Control Blk	     */
  NPUNITCB    pUnitCB;			/* Assoc. Unit Control Blk	     */
  NPVOLCHARS  pVolChar; 		/* Assoc. Volume Characteristics Blk */
  USHORT      LogDriveNum;		/* Logical  Drive Number	     */
  USHORT      PhysDriveNum;		/* Physical Drive Number	     */
  USHORT      FT_PartitionNumber;	/* Fault Tolerance partition number  */
  USHORT      Flags;			/*				     */
  UCHAR       PartitionType;		/* Partition Type		     */
  UCHAR       PhysPartitionNum; 	/* physical partition number	     */
  ULONG       PartitionOffset;		/* Partition Tbl Offset (RBA)	     */
  ULONG       ActualTotalSectors;	/* For physical VolCB, total sectors reported by       */ /*@V189588*/
					/*  geometry and NOT rounded down to cylinder boundary */ /*@V189588*/
  ULONG       NumPhysCylinders; 	/* Number cylinders on device	     */
  ULONG       NumLogCylinders;		/* Number cylinders on logical drive */
  ULONG       BootRecCyl;		/* Cyl of OS Boot Rec rel to MBR/EBR *//*@V89787*/
  BPB	      RecBPB;			/* Recommended BPB for drive	     */
  UCHAR       TruePartitionType;	/* partition type taken from table   */
  BPB	      MediaBPB; 		/* Current media BPB in drive	     */
  UCHAR       PartitionIndex;		/* entry found in part table at index*/
  HSYSNAME    hRMSysName;
} VOLCB;


/* Flags defines in VOLCB */
#define vf_NoDOSPartition	0x00000001
#define vf_TooBig		0x00000002
#define vf_Big			0x00000004
#define vf_InvBigPart		0x00000008
#define vf_BigFat		0x00000010
#define vf_ReturnFakeBPB	0x00000020
#define vf_ForceRdWrt		0x00000040
#define vf_UncertainMedia	0x00000080
#define vf_ChangedByFormat	0x00000100
#define vf_Changed		0x00000200
#define vf_OwnPhysical		0x00000400
#define vf_AmMult		0x00000800
#define vf_FTPartition		0x00001000
#define vf_noDisk		0x00002000
#define vf_NeedsStartUnit	0x00004000

#define vf_NoAssignedPartition	0x00008000			     /*@V187707*/
     // Placeholder volume for a UCF_REMOVABLE_AS_FIXED unit,	     /*@V187707*/
     // which currently has no associated partition.		     /*@V187707*/

/*--------------------------------------------------------------------*/
/*								      */
/* Unit Control Block						      */
/* ------------------						      */
/*								      */
/* This control blocks relates hardware devices to the Adapter	      */
/* Dependent Driver which manages them. 			      */
/*								      */
/*--------------------------------------------------------------------*/

typedef struct _PRTYQ
{
  PBYTE    Head;
  PBYTE    Tail;
} PRTYQ;

#define  NUM_RLE_QUEUES        9
#define  NUM_RP_QUEUES	       2

typedef struct _LOCKINFO       /* Keep info about Lock count and  */ /*@V51531*/
{			       /* removable media control support */ /*@V51531*/
   UCHAR  LockCount;						     /*@V51531*/
   BOOL   LockSupport;						     /*@V51531*/
} LOCKINFO;							     /*@V51531*/

typedef struct _UnitControlBlock
{
  NPUNITCB    pNextUnitCB;		  /* Pointer to Next UnitCB	  */
  NPVOLCB     pCurrentVolCB;		  /* Currently attached VolCB	  */
  USHORT      Flags;			  /* UnitCB Flags		  */
  USHORT      InterfaceType;		  /* scsi/atapi/other		  */
	  #define INTERFACE_SCSI 0
	  #define INTERFACE_ATAPI 1
  USHORT      PhysDriveNum;		  /* Physical Drive Number	  */
  UNITINFO    UnitInfo; 		  /* Additional Driver Info	  */
  USHORT      ADDHandle;		  /* ADD handle 		  */
  USHORT      AdapterNumber;		  /* Logical Adapter Number	  */
  ULONG       LastRBA;			  /* Last RBA for this unit	  */
  USHORT      MaxHWSGList;		  /* Max HW scatter/gather list   */
  NPIORBH     pDedicatedIORB;		  /* Dedicated IORB for this unit */
  VOID (FAR * AdapterDriverEP)();	  /* ADD Entry Point		  */
  USHORT      NumReqsInProgress;	  /* # of requests in progress	  */
  USHORT      NumReqsWaiting;		  /* Number of requests waiting   */
  USHORT      SortMethod;		  /* Sorting - fifo/elevator	  */ /*@V74404*/
  USHORT      QueueMethod;		  /* Queuing - priority/nopriority*/ /*@V74404*/
  USHORT      QueueDepth;		  /* Num reqs outstanding to ADD  */ /*@v74404*/
  NPIORBH     InProgressQueue;		  /* Queue of in progress requests*/
  PRTYQ       PrtyQRLE[NUM_RLE_QUEUES];   /* Priority Queues for RLE's    */
  PRTYQ       PrtyQRP[NUM_RP_QUEUES];	  /* Priority Queues for RP's     */
  HLDEV       hRMLDev;
  PVDB	      PerfViewDB;		  /* PerfView data block	  */

} UNITCB;

/* Flag definitions for Flags field in UNITCB */
#define UCF_IORB_ALLOCATED  0x0001	/* Dedicated IORB allocated	  */
#define UCF_HW_SCATGAT	    0x0002	/* Unit supports ScatGat in HW	  */
#define UCF_16M 	    0x0004	/* Unit supports > 16M addressing */
#define UCF_CHS_ADDRESSING  0x0008	/* Unit supports CHS Addressing   */
#define UCF_REMOVABLE_NON_FLOPPY  0x0010  /* Unit supports CHS Addressing */
#define UCF_REMOVABLE_AS_FIXED	  0x0020  /* treated as fixed */
#define UCF_FLOPPY_FMT_AS_FIXED   0x0040  /* Floppy formatted media treated as fixed */
#define UCF_REMOVABLE_PCCARD	  0x0080  /* Unit is PCCard		  */


/*--------------------------------------------------------------------*/
/* IORB DMWorkSpace Structure					      */
/*--------------------------------------------------------------------*/
typedef struct _IORB_DMWORK
{
   NPUNITCB	 pUnitCB;
   USHORT	 Flags; 					     /*@V55646*/
   PBYTE	 pRequest;
   SCATGATENTRY  SGList;
   ULONG	 Reserved_2;

} IORB_DMWORK, FAR *PIORB_DMWORK, NEAR *NPIORB_DMWORK;

/* Flags for IORB_DMWORK.Flags */
#define DMW_PERFVIEW_ACTIVE  0x0001 /* PerfView active when req. received */ /*@V55646*/

typedef struct _PARTITIONENTRY
{
   UCHAR	BootIndicator;
   UCHAR	BegHead;
   USHORT	BegSector:6;
   USHORT	BegCylinder:10;
   UCHAR	SysIndicator;
   UCHAR	EndHead;
   UCHAR	EndSector;
   UCHAR	EndCylinder;
   ULONG	RelativeSectors;
   ULONG	NumSectors;
} PARTITIONENTRY;


typedef struct _MBR
{
   UCHAR	  Pad[0x1BE];
   PARTITIONENTRY PartitionTable[4];
   USHORT	  Signature;
} MBR;


typedef struct _PARTITIONTABLE
{
   PARTITIONENTRY   PartitionTable[4];	/* buffer for partition table	     */
   USHORT	    Signature;
   UCHAR	    Bad_MBR;		/* 0 = MBR good, 1 = MBR is no good  */
   UCHAR	    No_PrimPart;	/* 0 = PP exits, 1 = no PP exists    */
   USHORT	    MapId;
} PARTITIONTABLE;

typedef struct _DOSBOOTREC
{
   UCHAR	  JmpCode;
   UCHAR	  Reserved_1;
   UCHAR	  nop;
   UCHAR	  Name[3];
   UCHAR	  Release[5];
   BPB		  bpb;
} DOSBOOTREC;


typedef struct _DRIVERENTRY
{
   UCHAR	DriverName[17];
   PFN		AdapterDriverEP;
} DRIVERENTRY;


typedef struct _DRIVERTABLE
{
   USHORT	NumDrivers;
   DRIVERENTRY	DriverEntry[MAX_DRIVERS];
} DRIVERTABLE;


typedef struct _FaultTolCB
{
UCHAR	Dummy;

} FaultTolCB;


typedef struct _DISKTABLE_ENTRY
{
   ULONG   NumSectors;
   UCHAR   Log2SectorsPerCluster;
   UCHAR   SectorsPerCluster;
   USHORT  MaxDirEntries;
   USHORT  Flags;

} DISKTABLE_ENTRY;


/*--------------------------------------------------------------*/
/* Init data allocated at the end of the data segment has the	*/
/* following structure: 					*/
/*--------------------------------------------------------------*/

#define MAX_DEVICE_TABLE_SIZE 1024

typedef struct _INITDATA
{
   UCHAR	   ScratchBuffer2[MAX_DEVICE_TABLE_SIZE];  /* Scratch buffer  */
   UCHAR	   ScratchIORB[MAX_IORB_SIZE]; /* IORB used during init       */
   RP_RWV	   InitPkt;		       /* RP used during init	      */
   PARTITIONTABLE  PartitionTables[MAX_FIXED_DISKS];  /* Array of partition tables */
} INITDATA;





