/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Clean;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.OutImpl;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamInImpl;
import org.w3c.tidy.TagTable;

public class Tidy
implements Serializable {
    static final long serialVersionUID = -2794371560623987718L;
    private boolean initialized = false;
    private PrintWriter errout = null;
    private PrintWriter stderr = null;
    private Configuration configuration = null;
    private String inputStreamName = "InputStream";
    private int parseErrors = 0;
    private int parseWarnings = 0;

    public Tidy() {
        this.init();
    }

    public void setErrout(PrintWriter printWriter) {
        this.errout = printWriter;
    }

    private void init() {
        this.configuration = new Configuration();
        if (this.configuration == null) {
            return;
        }
        AttributeTable attributeTable = AttributeTable.getDefaultAttributeTable();
        if (attributeTable == null) {
            return;
        }
        TagTable tagTable = new TagTable();
        if (tagTable == null) {
            return;
        }
        tagTable.setConfiguration(this.configuration);
        this.configuration.tt = tagTable;
        EntityTable entityTable = EntityTable.getDefaultEntityTable();
        if (entityTable == null) {
            return;
        }
        this.configuration.errfile = null;
        this.errout = this.stderr = new PrintWriter(System.err, true);
        this.initialized = true;
    }

    public Node parse(InputStream inputStream, OutputStream outputStream) {
        Node node = null;
        try {
            node = this.parse(inputStream, null, outputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return node;
    }

    private Node parse(InputStream inputStream, String string, OutputStream outputStream) throws FileNotFoundException, IOException {
        Node node = null;
        OutImpl outImpl = new OutImpl();
        if (!this.initialized) {
            return null;
        }
        if (this.errout == null) {
            return null;
        }
        this.parseErrors = 0;
        this.parseWarnings = 0;
        this.configuration.adjust();
        if (string != null) {
            inputStream = new FileInputStream(string);
            this.inputStreamName = string;
        } else if (inputStream == null) {
            inputStream = System.in;
            this.inputStreamName = "stdin";
        }
        if (inputStream != null) {
            Node node2;
            Object object;
            Lexer lexer = new Lexer(new StreamInImpl(inputStream, this.configuration.CharEncoding, this.configuration.tabsize), this.configuration);
            lexer.errout = this.errout;
            lexer.in.lexer = lexer;
            if (this.configuration.XmlTags) {
                node = ParserImpl.parseXMLDocument(lexer);
            } else {
                lexer.warnings = 0;
                if (!this.configuration.Quiet) {
                    Report.helloMessage(this.errout, "4th August 2000", this.inputStreamName);
                }
                if (!(node = ParserImpl.parseDocument(lexer)).checkNodeIntegrity()) {
                    Report.badTree(this.errout);
                    return null;
                }
                object = new Clean(this.configuration.tt);
                ((Clean)object).nestedEmphasis(node);
                ((Clean)object).list2BQ(node);
                ((Clean)object).bQ2Div(node);
                if (this.configuration.LogicalEmphasis) {
                    ((Clean)object).emFromI(node);
                }
                if (this.configuration.Word2000 && ((Clean)object).isWord2000(node, this.configuration.tt)) {
                    ((Clean)object).dropSections(lexer, node);
                    ((Clean)object).cleanWord2000(lexer, node);
                }
                if (this.configuration.MakeClean || this.configuration.DropFontTags) {
                    ((Clean)object).cleanTree(lexer, node);
                }
                if (!node.checkNodeIntegrity()) {
                    Report.badTree(this.errout);
                    return null;
                }
                node2 = node.findDocType();
                if (node.content != null) {
                    if (this.configuration.xHTML) {
                        lexer.setXHTMLDocType(node);
                    } else {
                        lexer.fixDocType(node);
                    }
                    if (this.configuration.TidyMark) {
                        lexer.addGenerator(node);
                    }
                }
                if (this.configuration.XmlOut && this.configuration.XmlPi) {
                    lexer.fixXMLPI(node);
                }
                if (!this.configuration.Quiet && node.content != null) {
                    Report.reportVersion(this.errout, lexer, this.inputStreamName, node2);
                    Report.reportNumWarnings(this.errout, lexer);
                }
            }
            this.parseWarnings = lexer.warnings;
            this.parseErrors = lexer.errors;
            if (string != null && inputStream != System.in) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (lexer.errors > 0) {
                Report.needsAuthorIntervention(this.errout);
            }
            outImpl.state = 0;
            outImpl.encoding = this.configuration.CharEncoding;
            if (!this.configuration.OnlyErrors && lexer.errors == 0) {
                if (this.configuration.BurstSlides) {
                    object = null;
                    node2 = node.findDocType();
                    if (node2 != null) {
                        Node.discardElement(node2);
                    }
                    lexer.versions = (short)(lexer.versions | 8);
                    if (this.configuration.xHTML) {
                        lexer.setXHTMLDocType(node);
                    } else {
                        lexer.fixDocType(node);
                    }
                    object = node.findBody(this.configuration.tt);
                    if (object != null) {
                        PPrint pPrint = new PPrint(this.configuration);
                        Report.reportNumberOfSlides(this.errout, pPrint.countSlides((Node)object));
                        pPrint.createSlides(lexer, node);
                    } else {
                        Report.missingBody(this.errout);
                    }
                } else if (this.configuration.writeback && string != null) {
                    try {
                        PPrint pPrint = new PPrint(this.configuration);
                        outImpl.out = new FileOutputStream(string);
                        if (this.configuration.XmlTags) {
                            pPrint.printXMLTree(outImpl, (short)0, 0, lexer, node);
                        } else {
                            pPrint.printTree(outImpl, (short)0, 0, lexer, node);
                        }
                        pPrint.flushLine(outImpl, 0);
                        outImpl.out.close();
                    }
                    catch (IOException iOException) {
                        this.errout.println(string + iOException.toString());
                    }
                } else if (outputStream != null) {
                    PPrint pPrint = new PPrint(this.configuration);
                    outImpl.out = outputStream;
                    if (this.configuration.XmlTags) {
                        pPrint.printXMLTree(outImpl, (short)0, 0, lexer, node);
                    } else {
                        pPrint.printTree(outImpl, (short)0, 0, lexer, node);
                    }
                    pPrint.flushLine(outImpl, 0);
                }
            }
            Report.errorSummary(lexer);
        }
        return node;
    }

    public Document parseDOM(InputStream inputStream, OutputStream outputStream) {
        Node node = this.parse(inputStream, outputStream);
        if (node != null) {
            return (Document)node.getAdapter();
        }
        return null;
    }
}

