/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.Hashtable;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheckImpl;
import org.w3c.tidy.Attribute;

public class AttributeTable {
    private Hashtable attributeHashtable = new Hashtable();
    private static AttributeTable defaultAttributeTable = null;
    private static Attribute[] attrs = new Attribute[]{new Attribute("abbr", 28, null), new Attribute("accept-charset", 28, null), new Attribute("accept", 31, null), new Attribute("accesskey", 28, null), new Attribute("action", 31, AttrCheckImpl.getCheckUrl()), new Attribute("add_date", 64, null), new Attribute("align", 31, AttrCheckImpl.getCheckAlign()), new Attribute("alink", 26, null), new Attribute("alt", 31, null), new Attribute("archive", 28, null), new Attribute("axis", 28, null), new Attribute("background", 26, AttrCheckImpl.getCheckUrl()), new Attribute("bgcolor", 26, null), new Attribute("bgproperties", 448, null), new Attribute("border", 31, AttrCheckImpl.getCheckBool()), new Attribute("bordercolor", 128, null), new Attribute("bottommargin", 128, null), new Attribute("cellpadding", 30, null), new Attribute("cellspacing", 30, null), new Attribute("char", 28, null), new Attribute("charoff", 28, null), new Attribute("charset", 28, null), new Attribute("checked", 31, AttrCheckImpl.getCheckBool()), new Attribute("cite", 28, AttrCheckImpl.getCheckUrl()), new Attribute("class", 28, null), new Attribute("classid", 28, AttrCheckImpl.getCheckUrl()), new Attribute("clear", 26, null), new Attribute("code", 26, null), new Attribute("codebase", 28, AttrCheckImpl.getCheckUrl()), new Attribute("codetype", 28, null), new Attribute("color", 26, null), new Attribute("cols", 24, null), new Attribute("colspan", 30, null), new Attribute("compact", 31, AttrCheckImpl.getCheckBool()), new Attribute("content", 31, null), new Attribute("coords", 30, null), new Attribute("data", 28, AttrCheckImpl.getCheckUrl()), new Attribute("datafld", 128, null), new Attribute("dataformatas", 128, null), new Attribute("datapagesize", 128, null), new Attribute("datasrc", 128, AttrCheckImpl.getCheckUrl()), new Attribute("datetime", 28, null), new Attribute("declare", 28, AttrCheckImpl.getCheckBool()), new Attribute("defer", 28, AttrCheckImpl.getCheckBool()), new Attribute("dir", 28, null), new Attribute("disabled", 28, AttrCheckImpl.getCheckBool()), new Attribute("enctype", 31, null), new Attribute("face", 26, null), new Attribute("for", 28, null), new Attribute("frame", 28, null), new Attribute("frameborder", 16, null), new Attribute("framespacing", 448, null), new Attribute("gridx", 448, null), new Attribute("gridy", 448, null), new Attribute("headers", 28, null), new Attribute("height", 31, null), new Attribute("href", 31, AttrCheckImpl.getCheckUrl()), new Attribute("hreflang", 28, null), new Attribute("hspace", 31, null), new Attribute("http-equiv", 31, null), new Attribute("id", 28, AttrCheckImpl.getCheckId()), new Attribute("ismap", 31, AttrCheckImpl.getCheckBool()), new Attribute("label", 28, null), new Attribute("lang", 28, null), new Attribute("language", 26, null), new Attribute("last_modified", 64, null), new Attribute("last_visit", 64, null), new Attribute("leftmargin", 128, null), new Attribute("link", 26, null), new Attribute("longdesc", 28, AttrCheckImpl.getCheckUrl()), new Attribute("lowsrc", 448, AttrCheckImpl.getCheckUrl()), new Attribute("marginheight", 24, null), new Attribute("marginwidth", 24, null), new Attribute("maxlength", 31, null), new Attribute("media", 28, null), new Attribute("method", 31, null), new Attribute("multiple", 31, AttrCheckImpl.getCheckBool()), new Attribute("name", 31, AttrCheckImpl.getCheckName()), new Attribute("nohref", 30, AttrCheckImpl.getCheckBool()), new Attribute("noresize", 16, AttrCheckImpl.getCheckBool()), new Attribute("noshade", 26, AttrCheckImpl.getCheckBool()), new Attribute("nowrap", 26, AttrCheckImpl.getCheckBool()), new Attribute("object", 8, null), new Attribute("onblur", 28, AttrCheckImpl.getCheckScript()), new Attribute("onchange", 28, AttrCheckImpl.getCheckScript()), new Attribute("onclick", 28, AttrCheckImpl.getCheckScript()), new Attribute("ondblclick", 28, AttrCheckImpl.getCheckScript()), new Attribute("onkeydown", 28, AttrCheckImpl.getCheckScript()), new Attribute("onkeypress", 28, AttrCheckImpl.getCheckScript()), new Attribute("onkeyup", 28, AttrCheckImpl.getCheckScript()), new Attribute("onload", 28, AttrCheckImpl.getCheckScript()), new Attribute("onmousedown", 28, AttrCheckImpl.getCheckScript()), new Attribute("onmousemove", 28, AttrCheckImpl.getCheckScript()), new Attribute("onmouseout", 28, AttrCheckImpl.getCheckScript()), new Attribute("onmouseover", 28, AttrCheckImpl.getCheckScript()), new Attribute("onmouseup", 28, AttrCheckImpl.getCheckScript()), new Attribute("onsubmit", 28, AttrCheckImpl.getCheckScript()), new Attribute("onreset", 28, AttrCheckImpl.getCheckScript()), new Attribute("onselect", 28, AttrCheckImpl.getCheckScript()), new Attribute("onunload", 28, AttrCheckImpl.getCheckScript()), new Attribute("onafterupdate", 128, AttrCheckImpl.getCheckScript()), new Attribute("onbeforeupdate", 128, AttrCheckImpl.getCheckScript()), new Attribute("onerrorupdate", 128, AttrCheckImpl.getCheckScript()), new Attribute("onrowenter", 128, AttrCheckImpl.getCheckScript()), new Attribute("onrowexit", 128, AttrCheckImpl.getCheckScript()), new Attribute("onbeforeunload", 128, AttrCheckImpl.getCheckScript()), new Attribute("ondatasetchanged", 128, AttrCheckImpl.getCheckScript()), new Attribute("ondataavailable", 128, AttrCheckImpl.getCheckScript()), new Attribute("ondatasetcomplete", 128, AttrCheckImpl.getCheckScript()), new Attribute("profile", 28, AttrCheckImpl.getCheckUrl()), new Attribute("prompt", 26, null), new Attribute("readonly", 28, AttrCheckImpl.getCheckBool()), new Attribute("rel", 31, null), new Attribute("rev", 31, null), new Attribute("rightmargin", 128, null), new Attribute("rows", 31, null), new Attribute("rowspan", 31, null), new Attribute("rules", 28, null), new Attribute("scheme", 28, null), new Attribute("scope", 28, null), new Attribute("scrolling", 24, null), new Attribute("selected", 31, AttrCheckImpl.getCheckBool()), new Attribute("shape", 30, null), new Attribute("showgrid", 448, AttrCheckImpl.getCheckBool()), new Attribute("showgridx", 448, AttrCheckImpl.getCheckBool()), new Attribute("showgridy", 448, AttrCheckImpl.getCheckBool()), new Attribute("size", 26, null), new Attribute("span", 28, null), new Attribute("src", 31, AttrCheckImpl.getCheckUrl()), new Attribute("standby", 28, null), new Attribute("start", 31, null), new Attribute("style", 28, null), new Attribute("summary", 28, null), new Attribute("tabindex", 28, null), new Attribute("target", 28, null), new Attribute("text", 26, null), new Attribute("title", 28, null), new Attribute("topmargin", 128, null), new Attribute("type", 30, null), new Attribute("usemap", 31, AttrCheckImpl.getCheckBool()), new Attribute("valign", 30, AttrCheckImpl.getCheckValign()), new Attribute("value", 31, null), new Attribute("valuetype", 28, null), new Attribute("version", 31, null), new Attribute("vlink", 26, null), new Attribute("vspace", 26, null), new Attribute("width", 31, null), new Attribute("wrap", 64, null), new Attribute("xml:lang", 32, null), new Attribute("xmlns", 31, null)};
    public static Attribute attrHref = null;
    public static Attribute attrSrc = null;
    public static Attribute attrId = null;
    public static Attribute attrName = null;
    public static Attribute attrSummary = null;
    public static Attribute attrAlt = null;
    public static Attribute attrLongdesc = null;
    public static Attribute attrUsemap = null;
    public static Attribute attrIsmap = null;
    public static Attribute attrLanguage = null;
    public static Attribute attrType = null;
    public static Attribute attrTitle = null;
    public static Attribute attrXmlns = null;
    public static Attribute attrValue = null;
    public static Attribute attrContent = null;
    public static Attribute attrDatafld = null;
    public static Attribute attrWidth = null;
    public static Attribute attrHeight = null;

    public Attribute lookup(String string) {
        return (Attribute)this.attributeHashtable.get(string);
    }

    public Attribute install(Attribute attribute) {
        return this.attributeHashtable.put(attribute.name, attribute);
    }

    public Attribute findAttribute(AttVal attVal) {
        if (attVal.attribute != null) {
            Attribute attribute = this.lookup(attVal.attribute);
            return attribute;
        }
        return null;
    }

    public boolean isUrl(String string) {
        Attribute attribute = this.lookup(string);
        return attribute != null && attribute.attrchk == AttrCheckImpl.getCheckUrl();
    }

    public boolean isScript(String string) {
        Attribute attribute = this.lookup(string);
        return attribute != null && attribute.attrchk == AttrCheckImpl.getCheckScript();
    }

    public static AttributeTable getDefaultAttributeTable() {
        if (defaultAttributeTable == null) {
            defaultAttributeTable = new AttributeTable();
            for (int i = 0; i < attrs.length; ++i) {
                defaultAttributeTable.install(attrs[i]);
            }
            attrHref = defaultAttributeTable.lookup("href");
            attrSrc = defaultAttributeTable.lookup("src");
            attrId = defaultAttributeTable.lookup("id");
            attrName = defaultAttributeTable.lookup("name");
            attrSummary = defaultAttributeTable.lookup("summary");
            attrAlt = defaultAttributeTable.lookup("alt");
            attrLongdesc = defaultAttributeTable.lookup("longdesc");
            attrUsemap = defaultAttributeTable.lookup("usemap");
            attrIsmap = defaultAttributeTable.lookup("ismap");
            attrLanguage = defaultAttributeTable.lookup("language");
            attrType = defaultAttributeTable.lookup("type");
            attrTitle = defaultAttributeTable.lookup("title");
            attrXmlns = defaultAttributeTable.lookup("xmlns");
            attrValue = defaultAttributeTable.lookup("value");
            attrContent = defaultAttributeTable.lookup("content");
            attrDatafld = defaultAttributeTable.lookup("datafld");
            attrWidth = defaultAttributeTable.lookup("width");
            attrHeight = defaultAttributeTable.lookup("height");
            AttributeTable.attrAlt.nowrap = true;
            AttributeTable.attrValue.nowrap = true;
            AttributeTable.attrContent.nowrap = true;
        }
        return defaultAttributeTable;
    }
}

