/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import mobac.utilities.tar.TarHeader;
import mobac.utilities.tar.TarIndexTable;
import org.apache.log4j.Logger;

public class TarIndex {
    private static final Logger log = Logger.getLogger(TarIndex.class);
    private File tarFile;
    private RandomAccessFile tarRAFile;
    private TarIndexTable tarIndex;

    public TarIndex(File tarFile, TarIndexTable tarIndex) throws FileNotFoundException {
        this.tarFile = tarFile;
        this.tarIndex = tarIndex;
        this.tarRAFile = new RandomAccessFile(tarFile, "r");
    }

    public byte[] getEntryContent(String entryName) throws IOException {
        long off = this.tarIndex.getEntryOffset(entryName);
        if (off < 0L) {
            return null;
        }
        this.tarRAFile.seek(off);
        byte[] buf = new byte[512];
        this.tarRAFile.readFully(buf);
        TarHeader th = new TarHeader();
        th.read(buf);
        int fileSize = th.getFileSizeInt();
        log.trace("reading file " + entryName + " off=" + off + " size=" + fileSize);
        byte[] data = new byte[fileSize];
        this.tarRAFile.readFully(data);
        return data;
    }

    public int size() {
        return this.tarIndex.size();
    }

    public void close() {
        try {
            this.tarRAFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeAndDelete() {
        this.close();
        this.tarFile.deleteOnExit();
        this.tarFile.delete();
    }
}

