/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipStoreOutputStream
extends ZipOutputStream {
    private CRC32 crc = new CRC32();

    public ZipStoreOutputStream(OutputStream out) {
        super(out);
    }

    public ZipStoreOutputStream(File f) throws FileNotFoundException {
        super(new FileOutputStream(f));
    }

    public void writeStoredEntry(String name, byte[] data) throws IOException {
        ZipEntry ze = new ZipEntry(name);
        ze.setMethod(0);
        ze.setCompressedSize(data.length);
        ze.setSize(data.length);
        this.crc.reset();
        this.crc.update(data);
        ze.setCrc(this.crc.getValue());
        this.putNextEntry(ze);
        this.write(data);
        this.closeEntry();
    }
}

