/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
extends FilterOutputStream {
    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    public final void writeInt(int v) throws IOException {
        byte[] work = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 24 & 0xFF)};
        this.out.write(work, 0, 4);
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeLong(long v) throws IOException {
        byte[] work = new byte[]{(byte)v, (byte)(v >> 8), (byte)(v >> 16), (byte)(v >> 24), (byte)(v >> 32), (byte)(v >> 40), (byte)(v >> 48), (byte)(v >> 56)};
        this.out.write(work);
    }
}

