/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.awt.Insets;
import mobac.utilities.GBC;

public class GBCTable {
    private final int colSpacing;
    private final int rowSpacing;
    private final GBC gbc = GBC.std();
    private int x;
    private int y;
    private int yBegin;

    public GBCTable() {
        this(4, 8);
    }

    public GBCTable(int spacing) {
        this(spacing, spacing);
    }

    public GBCTable(int rowSpacing, int colSpacing) {
        this.rowSpacing = rowSpacing;
        this.colSpacing = colSpacing;
        this.begin();
    }

    public GBC begin() {
        return this.begin(1, 1);
    }

    public GBC begin(int x, int y) {
        this.x = x;
        this.y = this.yBegin = y;
        this.reset();
        return this.gbc;
    }

    public GBC incX() {
        return this.nextCol(1);
    }

    public GBC nextCol(int x) {
        this.x += x;
        this.y = this.yBegin;
        this.reset();
        return this.gbc;
    }

    public GBC incY() {
        return this.nextRow(1);
    }

    public GBC nextRow(int y) {
        this.y += y;
        this.reset();
        return this.gbc;
    }

    private void reset() {
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        if (this.gbc.insets == null) {
            this.gbc.insets = new Insets(0, 0, 0, 0);
        } else {
            this.gbc.insets.right = 0;
            this.gbc.insets.left = 0;
            this.gbc.insets.bottom = 0;
            this.gbc.insets.top = 0;
        }
        this.gbc.gridx = this.x;
        if (this.gbc.gridx > 1) {
            this.gbc.insets.left = this.colSpacing;
        }
        if ((this.gbc.gridy = this.y) > 1) {
            this.gbc.insets.top = this.rowSpacing;
        }
    }
}

