/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilestore.berkeleydb;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.KeyField;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PrimaryKey;
import java.util.Date;
import mobac.program.tilestore.TileStoreEntry;

@Entity(version=3)
public class TileDbEntry
implements TileStoreEntry {
    @PrimaryKey
    protected TileDbKey tileKey;
    private byte[] data;
    private String eTag = null;
    private long timeDownloaded;
    private long timeLastModified;
    private long timeExpires;

    protected TileDbEntry() {
    }

    public TileDbEntry(int x, int y, int zoom, byte[] data) {
        this.tileKey = new TileDbKey(x, y, zoom);
        if (data == null) {
            throw new NullPointerException("Tile data can not be null!");
        }
        this.data = data;
        this.timeDownloaded = System.currentTimeMillis();
    }

    public TileDbEntry(int x, int y, int zoom, byte[] data, long timeLastModified, long timeExpires, String eTag) {
        this(x, y, zoom, data);
        this.timeLastModified = timeLastModified;
        this.timeExpires = timeExpires;
        this.eTag = eTag;
    }

    public void update(long timeExpires) {
        this.timeDownloaded = System.currentTimeMillis();
        this.timeExpires = timeExpires;
    }

    public int getX() {
        return this.tileKey.x;
    }

    public int getY() {
        return this.tileKey.y;
    }

    public int getZoom() {
        return this.tileKey.zoom;
    }

    public byte[] getData() {
        return this.data;
    }

    public String geteTag() {
        return this.eTag;
    }

    public long getTimeLastModified() {
        return this.timeLastModified;
    }

    public long getTimeDownloaded() {
        return this.timeDownloaded;
    }

    public long getTimeExpires() {
        return this.timeExpires;
    }

    public String shortInfo() {
        return String.format("Tile z%d/%d/%d", this.tileKey.zoom, this.tileKey.x, this.tileKey.y);
    }

    public String toString() {
        String tlm = this.timeLastModified <= 0L ? "-" : new Date(this.timeLastModified).toString();
        String txp = this.timeExpires <= 0L ? "-" : new Date(this.timeExpires).toString();
        return String.format("Tile z%d/%d/%d dl[%s] lm[%s] exp[%s] eTag[%s]", this.tileKey.zoom, this.tileKey.x, this.tileKey.y, new Date(this.timeDownloaded), tlm, txp, this.eTag);
    }

    @Persistent(version=3)
    public static class TileDbKey {
        @KeyField(value=1)
        public int zoom;
        @KeyField(value=2)
        public int x;
        @KeyField(value=3)
        public int y;

        protected TileDbKey() {
        }

        public TileDbKey(int x, int y, int zoom) {
            this.x = x;
            this.y = y;
            this.zoom = zoom;
        }

        public String toString() {
            return "[x=" + this.x + ", y=" + this.y + ", zoom=" + this.zoom + "]";
        }
    }
}

