/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tiledatawriter;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageType;
import mobac.program.tiledatawriter.ImageWriterWarningListener;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;

public class TileImageJpegDataWriter
implements TileImageDataWriter {
    protected static final Logger log = Logger.getLogger(TileImageJpegDataWriter.class);
    protected ImageWriter jpegImageWriter = null;
    protected ImageWriteParam iwp = null;
    protected float jpegCompressionLevel;

    public TileImageJpegDataWriter(double jpegCompressionLevel) {
        this((float)jpegCompressionLevel);
    }

    public TileImageJpegDataWriter(float jpegCompressionLevel) {
        this.jpegCompressionLevel = jpegCompressionLevel;
    }

    public TileImageJpegDataWriter(TileImageJpegDataWriter jpegWriter) {
        this(jpegWriter.getJpegCompressionLevel());
    }

    public void initialize() {
        if (log.isTraceEnabled()) {
            String s = "Available JPEG image writers:";
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            while (writers.hasNext()) {
                ImageWriter w = writers.next();
                s = s + "\n\t" + w.getClass().getName();
            }
            log.trace(s);
        }
        this.jpegImageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
        if (this.jpegImageWriter == null) {
            throw new NullPointerException("Unable to create a JPEG image writer");
        }
        this.jpegImageWriter.addIIOWriteWarningListener(ImageWriterWarningListener.INSTANCE);
        log.debug("Used JPEG image writer: " + this.jpegImageWriter.getClass().getName());
        this.iwp = this.jpegImageWriter.getDefaultWriteParam();
        this.iwp.setCompressionMode(2);
        this.iwp.setCompressionQuality(this.jpegCompressionLevel);
    }

    public void setJpegCompressionLevel(float jpegCompressionLevel) {
        this.jpegCompressionLevel = jpegCompressionLevel;
        this.iwp.setCompressionQuality(jpegCompressionLevel);
    }

    public float getJpegCompressionLevel() {
        return this.jpegCompressionLevel;
    }

    public void processImage(BufferedImage image, OutputStream out) throws IOException {
        if (image.getColorModel().hasAlpha()) {
            BufferedImage imageRGB = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            Graphics2D g = imageRGB.createGraphics();
            g.drawImage(image, null, 0, 0);
            g.dispose();
            image = imageRGB;
        }
        ImageOutputStream imageOut = ImageIO.createImageOutputStream(out);
        this.jpegImageWriter.setOutput(imageOut);
        IIOImage ioImage = new IIOImage(image, null, null);
        this.jpegImageWriter.write(null, ioImage, this.iwp);
    }

    public void dispose() {
        this.jpegImageWriter.dispose();
        this.jpegImageWriter = null;
    }

    public TileImageType getType() {
        return TileImageType.JPG;
    }

    public static boolean performOpenJDKJpegTest() {
        try {
            TileImageJpegDataWriter writer = new TileImageJpegDataWriter(0.99);
            writer.initialize();
            NullOutputStream out = new NullOutputStream();
            BufferedImage image = new BufferedImage(10, 10, 2);
            writer.processImage(image, out);
            return true;
        }
        catch (Exception e) {
            log.debug("Jpeg test failed", e);
            return false;
        }
    }
}

