/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import mobac.program.DirectoryManager;
import mobac.program.ProgramInfo;
import mobac.program.model.Bookmark;
import mobac.program.model.CoordinateStringFormat;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.ProxyType;
import mobac.program.model.SettingsPaperAtlas;
import mobac.program.model.SettingsWgsGrid;
import mobac.program.model.TileImageFormat;
import mobac.program.model.UnitSystem;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ThrottledInputStream;
import org.apache.log4j.Logger;

@XmlRootElement
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public class Settings {
    private static Logger log = Logger.getLogger(Settings.class);
    private static Settings instance = new Settings();
    public static final File FILE = new File(DirectoryManager.userSettingsDir, "settings.xml");
    private static long SETTINGS_LAST_MODIFIED = 0L;
    private static final String SYSTEM_PROXY_HOST = System.getProperty("http.proxyHost");
    private static final String SYSTEM_PROXY_PORT = System.getProperty("http.proxyPort");
    @XmlElement(defaultValue="")
    private String version;
    public int maxMapSize = 65536;
    public int mapOverlapTiles = 0;
    public boolean tileStoreEnabled = true;
    public int mapviewZoom = 3;
    public int mapviewGridZoom = -1;
    public EastNorthCoordinate mapviewCenterCoordinate = new EastNorthCoordinate(50.0, 9.0);
    public Point mapviewSelectionMax = null;
    public Point mapviewSelectionMin = null;
    @XmlElementWrapper(name="selectedZoomLevels")
    @XmlElement(name="zoomLevel")
    public List<Integer> selectedZoomLevels = null;
    @XmlElement(nillable=false)
    public String mapviewMapSource = null;
    public String elementName = "Layer";
    private String userAgent = null;
    public int downloadThreadCount = 2;
    public int downloadRetryCount = 1;
    private boolean customTileProcessing = false;
    private Dimension tileSize = new Dimension(256, 256);
    private TileImageFormat tileImageFormat = TileImageFormat.PNG;
    public CoordinateStringFormat coordinateNumberFormat = CoordinateStringFormat.DEG_LOCAL;
    public final Directories directories = new Directories();
    @XmlElementWrapper(name="placeBookmarks")
    @XmlElement(name="bookmark")
    public List<Bookmark> placeBookmarks = new ArrayList<Bookmark>();
    public int httpConnectionTimeout = 10;
    public int httpReadTimeout = 10;
    public long tileMaxExpirationTime = TimeUnit.DAYS.toMillis(365L);
    public long tileMinExpirationTime = TimeUnit.DAYS.toMillis(5L);
    public long tileDefaultExpirationTime = TimeUnit.DAYS.toMillis(28L);
    public String googleLanguage = "en";
    public String osmHikingTicket = "";
    @XmlElement
    public boolean devMode = false;
    public String gpxFileChooserDir = "";
    public final AtlasFormatSpecificSettings atlasFormatSpecificSettings = new AtlasFormatSpecificSettings();
    public final MainWindowSettings mainWindow = new MainWindowSettings();
    private ProxyType proxyType = ProxyType.CUSTOM;
    private String customProxyHost = "";
    private String customProxyPort = "";
    private String customProxyUserName = "";
    private String customProxyPassword = "";
    private long bandwidthLimit = 0L;
    @XmlElementWrapper(name="mapSourcesDisabled")
    @XmlElement(name="mapSource")
    public Vector<String> mapSourcesDisabled = new Vector();
    @XmlElementWrapper(name="mapSourcesEnabled")
    @XmlElement(name="mapSource")
    public Vector<String> mapSourcesEnabled = new Vector();
    @XmlElement(name="MapSourcesUpdate")
    public final MapSourcesUpdate mapSourcesUpdate = new MapSourcesUpdate();
    public transient UnitSystem unitSystem = UnitSystem.Metric;
    public final SettingsPaperAtlas paperAtlas = new SettingsPaperAtlas();
    public final SettingsWgsGrid wgsGrid = new SettingsWgsGrid();
    public boolean ignoreDlErrors = false;
    public String localeLanguage = null;
    public String localeCountry = null;

    private Settings() {
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainWindow.size.width = (int)(0.9f * (float)dScreen.width);
        this.mainWindow.size.height = (int)(0.9f * (float)dScreen.height);
        this.mainWindow.collapsedPanels.add("Coordinates");
        this.mainWindow.collapsedPanels.add("Gpx");
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale.equals(new Locale("zh", "CN"))) {
            this.localeLanguage = "zh";
            this.localeCountry = "CN";
        } else if (defaultLocale.equals(new Locale("zh", "TW"))) {
            this.localeLanguage = "zh";
            this.localeCountry = "TW";
        } else if (defaultLocale.equals(new Locale("ja", "JP"))) {
            this.localeLanguage = "ja";
            this.localeCountry = "JP";
        } else if (defaultLocale.equals(new Locale("fr", "FR"))) {
            this.localeLanguage = "fr";
            this.localeCountry = "FR";
        } else {
            this.localeLanguage = "en";
            this.localeCountry = "";
        }
    }

    public static Settings getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws JAXBException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Unmarshaller um = context.createUnmarshaller();
            um.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    log.warn("Problem on loading settings.xml: " + event.getMessage());
                    return true;
                }
            });
            instance = (Settings)um.unmarshal(FILE);
            Settings.instance.wgsGrid.checkValues();
            Settings.instance.paperAtlas.checkValues();
            SETTINGS_LAST_MODIFIED = FILE.lastModified();
            I18nUtils.updateLocalizedStringFormSettings();
        }
        finally {
            Settings s = Settings.getInstance();
            s.applyProxySettings();
        }
    }

    public static boolean checkSettingsFileModified() {
        if (SETTINGS_LAST_MODIFIED == 0L) {
            return false;
        }
        long lastModified = FILE.lastModified();
        return SETTINGS_LAST_MODIFIED != lastModified;
    }

    public static void save() throws JAXBException {
        Settings.getInstance().version = ProgramInfo.getVersion();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream bo = null;
        FileOutputStream fo = null;
        try {
            bo = new ByteArrayOutputStream();
            m.marshal((Object)Settings.getInstance(), (OutputStream)bo);
            fo = new FileOutputStream(FILE);
            fo.write(bo.toByteArray());
            fo.close();
            SETTINGS_LAST_MODIFIED = FILE.lastModified();
        }
        catch (IOException e) {
            try {
                throw new JAXBException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fo);
                throw throwable;
            }
        }
        Utilities.closeStream(fo);
    }

    public static void loadOrQuit() {
        try {
            Settings.load();
        }
        catch (JAXBException e) {
            log.error((Object)e);
            JOptionPane.showMessageDialog(null, I18nUtils.localizedStringForKey(I18nUtils.localizedStringForKey("msg_settings_file_can_not_parse", new Object[0]), new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
            System.exit(0);
        }
    }

    public String getUserAgent() {
        if (this.userAgent != null) {
            return this.userAgent;
        }
        return ProgramInfo.getUserAgent();
    }

    public void setUserAgent(String userAgent) {
        if (userAgent != null && (userAgent = userAgent.trim()).length() == 0) {
            userAgent = null;
        }
        this.userAgent = userAgent;
    }

    public boolean isCustomTileSize() {
        return this.customTileProcessing;
    }

    public void setCustomTileSize(boolean customTileSize) {
        this.customTileProcessing = customTileSize;
    }

    public Dimension getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Dimension tileSize) {
        this.tileSize = tileSize;
    }

    public TileImageFormat getTileImageFormat() {
        return this.tileImageFormat;
    }

    public void setTileImageFormat(TileImageFormat tileImageFormat) {
        this.tileImageFormat = tileImageFormat;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public String getCustomProxyHost() {
        return this.customProxyHost;
    }

    public String getCustomProxyPort() {
        return this.customProxyPort;
    }

    public void setCustomProxyHost(String proxyHost) {
        this.customProxyHost = proxyHost;
    }

    public void setCustomProxyPort(String proxyPort) {
        this.customProxyPort = proxyPort;
    }

    public String getCustomProxyUserName() {
        return this.customProxyUserName;
    }

    public void setCustomProxyUserName(String customProxyUserName) {
        this.customProxyUserName = customProxyUserName;
    }

    public String getCustomProxyPassword() {
        return this.customProxyPassword;
    }

    public void setCustomProxyPassword(String customProxyPassword) {
        this.customProxyPassword = customProxyPassword;
    }

    public void applyProxySettings() {
        boolean useSystemProxies = false;
        String newProxyHost = null;
        String newProxyPort = null;
        Authenticator newAuthenticator = null;
        switch (this.proxyType) {
            case SYSTEM: {
                log.info("Applying proxy configuration: system settings");
                useSystemProxies = true;
                break;
            }
            case APP_SETTINGS: {
                newProxyHost = SYSTEM_PROXY_HOST;
                newProxyPort = SYSTEM_PROXY_PORT;
                log.info("Applying proxy configuration: host=" + newProxyHost + " port=" + newProxyPort);
                break;
            }
            case CUSTOM: {
                newProxyHost = this.customProxyHost;
                newProxyPort = this.customProxyPort;
                log.info("Applying proxy configuration: host=" + newProxyHost + " port=" + newProxyPort);
                break;
            }
            case CUSTOM_W_AUTH: {
                newProxyHost = this.customProxyHost;
                newProxyPort = this.customProxyPort;
                newAuthenticator = new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(Settings.this.customProxyUserName, Settings.this.customProxyPassword.toCharArray());
                    }
                };
                log.info("Applying proxy configuration: host=" + newProxyHost + " port=" + newProxyPort + " user=" + this.customProxyUserName);
            }
        }
        Utilities.setHttpProxyHost(newProxyHost);
        Utilities.setHttpProxyPort(newProxyPort);
        Authenticator.setDefault(newAuthenticator);
        System.setProperty("java.net.useSystemProxies", Boolean.toString(useSystemProxies));
    }

    public long getBandwidthLimit() {
        return this.bandwidthLimit;
    }

    public void setBandwidthLimit(long bandwidthLimit) {
        this.bandwidthLimit = bandwidthLimit;
        ThrottledInputStream.setBandwidth(bandwidthLimit);
    }

    @XmlElement
    public void setUnitSystem(UnitSystem unitSystem) {
        if (unitSystem == null) {
            unitSystem = UnitSystem.Metric;
        }
        this.unitSystem = unitSystem;
    }

    public UnitSystem getUnitSystem() {
        return this.unitSystem;
    }

    @XmlTransient
    public File getMapSourcesDirectory() {
        String mapSourcesDirCfg = this.directories.mapSourcesDirectory;
        File mapSourcesDir = mapSourcesDirCfg == null || mapSourcesDirCfg.trim().length() == 0 ? DirectoryManager.mapSourcesDir : new File(mapSourcesDirCfg);
        return mapSourcesDir;
    }

    @XmlTransient
    public File getAtlasOutputDirectory() {
        if (this.directories.atlasOutputDirectory != null) {
            return new File(this.directories.atlasOutputDirectory);
        }
        return new File(DirectoryManager.currentDir, "atlases");
    }

    public String getAtlasOutputDirectoryString() {
        if (this.directories.atlasOutputDirectory == null) {
            return "";
        }
        return this.directories.atlasOutputDirectory;
    }

    public void setAtlasOutputDirectory(String dir) {
        if (dir != null && dir.trim().length() == 0) {
            dir = null;
        }
        this.directories.atlasOutputDirectory = dir;
    }

    public String getVersion() {
        return this.version;
    }

    public static class MapSourcesUpdate {
        public String etag;
        public Date lastUpdate;
    }

    public static class MainWindowSettings {
        public Dimension size = new Dimension();
        public Point position = new Point(-1, -1);
        public boolean maximized = true;
        public boolean leftPanelVisible = true;
        public boolean rightPanelVisible = true;
        @XmlElementWrapper(name="collapsedPanels")
        @XmlElement(name="collapsedPanel")
        public Vector<String> collapsedPanels = new Vector();
    }

    public static class AtlasFormatSpecificSettings {
        @XmlElement
        public Integer garminCustomMaxMapCount = 100;
    }

    public static class Directories {
        @XmlElement
        private String atlasOutputDirectory = null;
        @XmlElement
        public String tileStoreDirectory;
        @XmlElement
        private String mapSourcesDirectory;
    }
}

