/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import mobac.program.DirectoryManager;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.model.Atlas;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
implements Comparable<Profile> {
    private static Logger log = Logger.getLogger(Profile.class);
    public static final String PROFILE_NAME_REGEX = "[\\w _-]+";
    public static final String PROFILE_FILENAME_PREFIX = "mobac-profile-";
    public static final Pattern PROFILE_FILENAME_PATTERN = Pattern.compile("mobac-profile-([\\w _-]+).xml");
    public static final Profile DEFAULT = new Profile();
    private File file;
    private String name;
    private static Vector<Profile> profiles = new Vector();

    public static void updateProfiles() {
        File profilesDir = DirectoryManager.atlasProfilesDir;
        final HashSet<Profile> deletedProfiles = new HashSet<Profile>();
        deletedProfiles.addAll(profiles);
        profilesDir.list(new FilenameFilter(){

            public boolean accept(File dir, String fileName) {
                String profileName;
                Profile profile;
                Matcher m = PROFILE_FILENAME_PATTERN.matcher(fileName);
                if (m.matches() && !deletedProfiles.remove(profile = new Profile(new File(dir, fileName), profileName = m.group(1)))) {
                    profiles.add(profile);
                }
                return false;
            }
        });
        for (Profile p : deletedProfiles) {
            profiles.remove(p);
        }
        Collections.sort(profiles);
    }

    public static Vector<Profile> getProfiles() {
        Profile.updateProfiles();
        return profiles;
    }

    public Profile(String name) {
        this(new File(DirectoryManager.atlasProfilesDir, Profile.getProfileFileName(name)), name);
    }

    protected Profile() {
        this(new File(DirectoryManager.atlasProfilesDir, "mobac-profile.xml"), "");
    }

    protected Profile(File file, String name) {
        this.file = file;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        return this.file.isFile();
    }

    public void delete() {
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
    }

    @Override
    public int compareTo(Profile o) {
        return this.file.compareTo(o.file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile p = (Profile)obj;
        return this.file.equals(p.file);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return -1;
    }

    public void save(AtlasInterface atlasInterface) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Atlas.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(this.file);
            m.marshal((Object)atlasInterface, (OutputStream)fo);
        }
        catch (FileNotFoundException e) {
            try {
                throw new JAXBException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fo);
                throw throwable;
            }
        }
        Utilities.closeStream(fo);
    }

    public AtlasInterface load() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Atlas.class});
        Unmarshaller um = context.createUnmarshaller();
        um.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                ValidationEventLocator loc = event.getLocator();
                String file = loc.getURL().getFile();
                int lastSlash = file.lastIndexOf(47);
                if (lastSlash > 0) {
                    file = file.substring(lastSlash + 1);
                }
                int ret = JOptionPane.showConfirmDialog(null, String.format(I18nUtils.localizedStringForKey("msg_error_load_atlas_profile", new Object[0]), event.getMessage(), file, loc.getLineNumber(), loc.getColumnNumber()), I18nUtils.localizedStringForKey("msg_error_load_atlas_profile_title", new Object[0]), 1, 0);
                log.error(event.toString());
                return ret == 0;
            }
        });
        try {
            AtlasInterface newAtlas = (AtlasInterface)um.unmarshal(this.file);
            return newAtlas;
        }
        catch (Exception e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean checkAtlas(AtlasInterface atlasInterface) {
        return Profile.checkAtlasObject(atlasInterface);
    }

    public static String getProfileFileName(String profileName) {
        return PROFILE_FILENAME_PREFIX + profileName + ".xml";
    }

    private static boolean checkAtlasObject(Object o) {
        boolean result = false;
        if (o instanceof AtlasObject) {
            result |= ((AtlasObject)o).checkData();
        }
        if (o instanceof Iterable) {
            Iterable it = (Iterable)o;
            for (Object ao : it) {
                result |= Profile.checkAtlasObject(ao);
            }
        }
        return result;
    }
}

