/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.program.model.EastNorthCoordinate;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Bookmark
extends EastNorthCoordinate {
    @XmlAttribute
    protected int zoom;
    @XmlAttribute
    protected String name;
    @XmlAttribute
    protected String mapSource;

    private Bookmark() {
    }

    public Bookmark(MapSource mapSource, int zoom, int pixelCoordinateX, int pixelCoordinateY) {
        this(null, mapSource, zoom, pixelCoordinateX, pixelCoordinateY);
    }

    public Bookmark(String name, MapSource mapSource, int zoom, int pixelCoordinateX, int pixelCoordinateY) {
        super(mapSource.getMapSpace(), zoom, pixelCoordinateX, pixelCoordinateY);
        this.mapSource = mapSource.getName();
        this.zoom = zoom;
        this.name = name;
    }

    public MapSource getMapSource() {
        return MapSourcesManager.getInstance().getSourceByName(this.mapSource);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setName(String name) {
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return String.format("%s at lat=%.3f lon=%.3f (zoom = %d)", this.mapSource, this.lat, this.lon, this.zoom);
    }
}

